/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.StateMapping;
import de.flapdoodle.reverse.TransitionMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TransitionMapping", generator="Immutables")
public final class ImmutableTransitionMapping<D>
extends TransitionMapping<D> {
    private final StateMapping<D> destination;
    private final List<StateMapping<?>> mappings;

    private ImmutableTransitionMapping(StateMapping<D> destination, List<StateMapping<?>> mappings) {
        this.destination = destination;
        this.mappings = mappings;
    }

    @Override
    public StateMapping<D> destination() {
        return this.destination;
    }

    @Override
    public List<StateMapping<?>> mappings() {
        return this.mappings;
    }

    public final ImmutableTransitionMapping<D> withDestination(StateMapping<D> value) {
        if (this.destination == value) {
            return this;
        }
        StateMapping<D> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableTransitionMapping<D>(newValue, this.mappings);
    }

    @SafeVarargs
    public final ImmutableTransitionMapping<D> withMappings(StateMapping<?> ... elements) {
        List<StateMapping<?>> newValue = ImmutableTransitionMapping.createUnmodifiableList(false, ImmutableTransitionMapping.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTransitionMapping<D>(this.destination, newValue);
    }

    public final ImmutableTransitionMapping<D> withMappings(Iterable<? extends StateMapping<?>> elements) {
        if (this.mappings == elements) {
            return this;
        }
        List<StateMapping<?>> newValue = ImmutableTransitionMapping.createUnmodifiableList(false, ImmutableTransitionMapping.createSafeList(elements, true, false));
        return new ImmutableTransitionMapping<D>(this.destination, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransitionMapping && this.equalTo((ImmutableTransitionMapping)another);
    }

    private boolean equalTo(ImmutableTransitionMapping<?> another) {
        return this.destination.equals(another.destination) && this.mappings.equals(another.mappings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.mappings.hashCode();
        return h;
    }

    public String toString() {
        return "TransitionMapping{destination=" + this.destination + ", mappings=" + this.mappings + "}";
    }

    public static <D> ImmutableTransitionMapping<D> copyOf(TransitionMapping<D> instance) {
        if (instance instanceof ImmutableTransitionMapping) {
            return (ImmutableTransitionMapping)instance;
        }
        return ImmutableTransitionMapping.builder().from(instance).build();
    }

    public static <D> Builder<D> builder(StateMapping<D> destination) {
        return new Builder(destination);
    }

    static <D> Builder<D> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TransitionMapping", generator="Immutables")
    public static final class Builder<D> {
        private static final long INIT_BIT_DESTINATION = 1L;
        private long initBits = 1L;
        private StateMapping<D> destination;
        private List<StateMapping<?>> mappings = new ArrayList();

        private Builder(StateMapping<D> destination) {
            this.destination(destination);
        }

        private Builder() {
        }

        public final Builder<D> from(TransitionMapping<D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.destination(instance.destination());
            this.addAllMappings(instance.mappings());
            return this;
        }

        final Builder<D> destination(StateMapping<D> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<D> addMappings(StateMapping<?> element) {
            this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            return this;
        }

        @SafeVarargs
        public final Builder<D> addMappings(StateMapping<?> ... elements) {
            for (StateMapping<?> element : elements) {
                this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            }
            return this;
        }

        public final Builder<D> mappings(Iterable<? extends StateMapping<?>> elements) {
            this.mappings.clear();
            return this.addAllMappings(elements);
        }

        public final Builder<D> addAllMappings(Iterable<? extends StateMapping<?>> elements) {
            for (StateMapping<?> element : elements) {
                this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            }
            return this;
        }

        public ImmutableTransitionMapping<D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransitionMapping(this.destination, ImmutableTransitionMapping.createUnmodifiableList(true, this.mappings));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destination");
            }
            return "Cannot build TransitionMapping, some of required attributes are not set " + attributes;
        }
    }
}

