/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.edges.Join;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

@Generated(from="Join", generator="Immutables")
public final class ImmutableJoin<L, R, D>
extends Join<L, R, D> {
    private final StateID<L> left;
    private final StateID<R> right;
    private final StateID<D> destination;
    private final BiFunction<L, R, State<D>> action;
    private final String transitionLabel;
    private volatile transient long lazyInitBitmap;
    private static final long SOURCES_LAZY_INIT_BIT = 1L;
    private transient Set<StateID<?>> sources;

    private ImmutableJoin(Builder<L, R, D> builder) {
        this.left = ((Builder)builder).left;
        this.right = ((Builder)builder).right;
        this.destination = ((Builder)builder).destination;
        this.action = ((Builder)builder).action;
        this.transitionLabel = ((Builder)builder).transitionLabel != null ? ((Builder)builder).transitionLabel : Objects.requireNonNull(super.transitionLabel(), "transitionLabel");
    }

    private ImmutableJoin(StateID<L> left, StateID<R> right, StateID<D> destination, BiFunction<L, R, State<D>> action, String transitionLabel) {
        this.left = left;
        this.right = right;
        this.destination = destination;
        this.action = action;
        this.transitionLabel = transitionLabel;
    }

    @Override
    public StateID<L> left() {
        return this.left;
    }

    @Override
    public StateID<R> right() {
        return this.right;
    }

    @Override
    public StateID<D> destination() {
        return this.destination;
    }

    @Override
    protected BiFunction<L, R, State<D>> action() {
        return this.action;
    }

    @Override
    public String transitionLabel() {
        return this.transitionLabel;
    }

    public final ImmutableJoin<L, R, D> withLeft(StateID<L> value) {
        if (this.left == value) {
            return this;
        }
        StateID<L> newValue = Objects.requireNonNull(value, "left");
        return new ImmutableJoin<L, R, D>(newValue, this.right, this.destination, this.action, this.transitionLabel);
    }

    public final ImmutableJoin<L, R, D> withRight(StateID<R> value) {
        if (this.right == value) {
            return this;
        }
        StateID<R> newValue = Objects.requireNonNull(value, "right");
        return new ImmutableJoin<L, R, D>(this.left, newValue, this.destination, this.action, this.transitionLabel);
    }

    public final ImmutableJoin<L, R, D> withDestination(StateID<D> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<D> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableJoin<L, R, D>(this.left, this.right, newValue, this.action, this.transitionLabel);
    }

    public final ImmutableJoin<L, R, D> withAction(BiFunction<L, R, State<D>> value) {
        if (this.action == value) {
            return this;
        }
        BiFunction<L, R, State<D>> newValue = Objects.requireNonNull(value, "action");
        return new ImmutableJoin<L, R, D>(this.left, this.right, this.destination, newValue, this.transitionLabel);
    }

    public final ImmutableJoin<L, R, D> withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableJoin<L, R, D>(this.left, this.right, this.destination, this.action, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoin && this.equalTo((ImmutableJoin)another);
    }

    private boolean equalTo(ImmutableJoin<?, ?, ?> another) {
        return this.left.equals(another.left) && this.right.equals(another.right) && this.destination.equals(another.destination) && this.action.equals(another.action) && this.transitionLabel.equals(another.transitionLabel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.left.hashCode();
        h += (h << 5) + this.right.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.transitionLabel.hashCode();
        return h;
    }

    public String toString() {
        return "Join{left=" + this.left + ", right=" + this.right + ", destination=" + this.destination + ", action=" + this.action + ", transitionLabel=" + this.transitionLabel + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<StateID<?>> sources() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableJoin immutableJoin = this;
            synchronized (immutableJoin) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.sources = Objects.requireNonNull(super.sources(), "sources");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.sources;
    }

    public static <L, R, D> ImmutableJoin<L, R, D> copyOf(Join<L, R, D> instance) {
        if (instance instanceof ImmutableJoin) {
            return (ImmutableJoin)instance;
        }
        return ImmutableJoin.builder().from(instance).build();
    }

    public static <L, R, D> Builder<L, R, D> builder() {
        return new Builder();
    }

    @Generated(from="Join", generator="Immutables")
    public static final class Builder<L, R, D> {
        private static final long INIT_BIT_LEFT = 1L;
        private static final long INIT_BIT_RIGHT = 2L;
        private static final long INIT_BIT_DESTINATION = 4L;
        private static final long INIT_BIT_ACTION = 8L;
        private long initBits = 15L;
        private StateID<L> left;
        private StateID<R> right;
        private StateID<D> destination;
        private BiFunction<L, R, State<D>> action;
        private String transitionLabel;

        private Builder() {
        }

        public final Builder<L, R, D> from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<L, R, D> from(Join<L, R, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasLabel instance;
            long bits = 0L;
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
            if (object instanceof Join) {
                instance = (Join)object;
                this.destination(((Join)instance).destination());
                this.action(((Join)instance).action());
                this.right(((Join)instance).right());
                this.left(((Join)instance).left());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(((Join)instance).transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder<L, R, D> left(StateID<L> left) {
            this.left = Objects.requireNonNull(left, "left");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<L, R, D> right(StateID<R> right) {
            this.right = Objects.requireNonNull(right, "right");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<L, R, D> destination(StateID<D> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<L, R, D> action(BiFunction<L, R, State<D>> action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<L, R, D> transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public ImmutableJoin<L, R, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJoin(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("left");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("right");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build Join, some of required attributes are not set " + attributes;
        }
    }
}

