/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.edges.Derive;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.immutables.value.Generated;

@Generated(from="Derive", generator="Immutables")
public final class ImmutableDerive<S, D>
extends Derive<S, D> {
    private final StateID<S> source;
    private final StateID<D> destination;
    private final Function<S, State<D>> action;
    private final String transitionLabel;
    private volatile transient long lazyInitBitmap;
    private static final long SOURCES_LAZY_INIT_BIT = 1L;
    private transient Set<StateID<?>> sources;

    private ImmutableDerive(Builder<S, D> builder) {
        this.source = ((Builder)builder).source;
        this.destination = ((Builder)builder).destination;
        this.action = ((Builder)builder).action;
        this.transitionLabel = ((Builder)builder).transitionLabel != null ? ((Builder)builder).transitionLabel : Objects.requireNonNull(super.transitionLabel(), "transitionLabel");
    }

    private ImmutableDerive(StateID<S> source, StateID<D> destination, Function<S, State<D>> action, String transitionLabel) {
        this.source = source;
        this.destination = destination;
        this.action = action;
        this.transitionLabel = transitionLabel;
    }

    @Override
    public StateID<S> source() {
        return this.source;
    }

    @Override
    public StateID<D> destination() {
        return this.destination;
    }

    @Override
    protected Function<S, State<D>> action() {
        return this.action;
    }

    @Override
    public String transitionLabel() {
        return this.transitionLabel;
    }

    public final ImmutableDerive<S, D> withSource(StateID<S> value) {
        if (this.source == value) {
            return this;
        }
        StateID<S> newValue = Objects.requireNonNull(value, "source");
        return new ImmutableDerive<S, D>(newValue, this.destination, this.action, this.transitionLabel);
    }

    public final ImmutableDerive<S, D> withDestination(StateID<D> value) {
        if (this.destination == value) {
            return this;
        }
        StateID<D> newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableDerive<S, D>(this.source, newValue, this.action, this.transitionLabel);
    }

    public final ImmutableDerive<S, D> withAction(Function<S, State<D>> value) {
        if (this.action == value) {
            return this;
        }
        Function<S, State<D>> newValue = Objects.requireNonNull(value, "action");
        return new ImmutableDerive<S, D>(this.source, this.destination, newValue, this.transitionLabel);
    }

    public final ImmutableDerive<S, D> withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableDerive<S, D>(this.source, this.destination, this.action, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDerive && this.equalTo((ImmutableDerive)another);
    }

    private boolean equalTo(ImmutableDerive<?, ?> another) {
        return this.source.equals(another.source) && this.destination.equals(another.destination) && this.action.equals(another.action) && this.transitionLabel.equals(another.transitionLabel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.transitionLabel.hashCode();
        return h;
    }

    public String toString() {
        return "Derive{source=" + this.source + ", destination=" + this.destination + ", action=" + this.action + ", transitionLabel=" + this.transitionLabel + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<StateID<?>> sources() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDerive immutableDerive = this;
            synchronized (immutableDerive) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.sources = Objects.requireNonNull(super.sources(), "sources");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.sources;
    }

    public static <S, D> ImmutableDerive<S, D> copyOf(Derive<S, D> instance) {
        if (instance instanceof ImmutableDerive) {
            return (ImmutableDerive)instance;
        }
        return ImmutableDerive.builder().from(instance).build();
    }

    public static <S, D> Builder<S, D> builder() {
        return new Builder();
    }

    @Generated(from="Derive", generator="Immutables")
    public static final class Builder<S, D> {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_ACTION = 4L;
        private long initBits = 7L;
        private StateID<S> source;
        private StateID<D> destination;
        private Function<S, State<D>> action;
        private String transitionLabel;

        private Builder() {
        }

        public final Builder<S, D> from(Derive<S, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<S, D> from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasLabel instance;
            long bits = 0L;
            if (object instanceof Derive) {
                instance = (Derive)object;
                this.destination(((Derive)instance).destination());
                this.action(((Derive)instance).action());
                this.source(((Derive)instance).source());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(((Derive)instance).transitionLabel());
                    bits |= 1L;
                }
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder<S, D> source(StateID<S> source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, D> destination(StateID<D> destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, D> action(Function<S, State<D>> action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<S, D> transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            return this;
        }

        public ImmutableDerive<S, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDerive(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build Derive, some of required attributes are not set " + attributes;
        }
    }
}

