package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Start}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStart.builder()}.
 */
@Generated(from = "Start", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStart<D> extends Start<D> {
  private final StateID<D> destination;
  private final Supplier<State<D>> action;

  private ImmutableStart(
      StateID<D> destination,
      Supplier<State<D>> action) {
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  protected Supplier<State<D>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Start#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStart<D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableStart<>(newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Start#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStart<D> withAction(Supplier<State<D>> value) {
    if (this.action == value) return this;
    Supplier<State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableStart<>(this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStart} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStart<?>
        && equalTo((ImmutableStart<?>) another);
  }

  private boolean equalTo(ImmutableStart<?> another) {
    return destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Start} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Start{"
        + "destination=" + destination
        + ", action=" + action
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SOURCES_LAZY_INIT_BIT = 0x1L;

  private transient Set<StateID<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Start#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<StateID<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Creates an immutable copy of a {@link Start} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Start instance
   */
  public static <D> ImmutableStart<D> copyOf(Start<D> instance) {
    if (instance instanceof ImmutableStart<?>) {
      return (ImmutableStart<D>) instance;
    }
    return ImmutableStart.<D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStart ImmutableStart}.
   * <pre>
   * ImmutableStart.&amp;lt;D&amp;gt;builder()
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;D&amp;gt;) // required {@link Start#destination() destination}
   *    .action(function.Supplier&amp;lt;de.flapdoodle.reverse.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Start#action() action}
   *    .build();
   * </pre>
   * @param <D> generic parameter D
   * @return A new ImmutableStart builder
   */
  public static <D> ImmutableStart.Builder<D> builder() {
    return new ImmutableStart.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStart ImmutableStart}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Start", generator = "Immutables")
  public static final class Builder<D> {
    private static final long INIT_BIT_DESTINATION = 0x1L;
    private static final long INIT_BIT_ACTION = 0x2L;
    private long initBits = 0x3L;

    private StateID<D> destination;
    private Supplier<State<D>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.edges.Start} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> from(Start<D> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.reverse.Transition} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> from(Transition<D> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      long bits = 0;
      if (object instanceof Start<?>) {
        Start<D> instance = (Start<D>) object;
        if ((bits & 0x1L) == 0) {
          destination(instance.destination());
          bits |= 0x1L;
        }
        action(instance.action());
      }
      if (object instanceof Transition<?>) {
        Transition<D> instance = (Transition<D>) object;
        if ((bits & 0x1L) == 0) {
          destination(instance.destination());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Start#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Start#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> action(Supplier<State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStart ImmutableStart}.
     * @return An immutable instance of Start
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStart<D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStart<>(destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Start, some of required attributes are not set " + attributes;
    }
  }
}
