package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Join}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJoin.builder()}.
 */
@Generated(from = "Join", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJoin<L, R, D> extends Join<L, R, D> {
  private final StateID<L> left;
  private final StateID<R> right;
  private final StateID<D> destination;
  private final BiFunction<L, R, State<D>> action;

  private ImmutableJoin(
      StateID<L> left,
      StateID<R> right,
      StateID<D> destination,
      BiFunction<L, R, State<D>> action) {
    this.left = left;
    this.right = right;
    this.destination = destination;
    this.action = action;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public StateID<L> left() {
    return left;
  }

  /**
   * @return The value of the {@code right} attribute
   */
  @Override
  public StateID<R> right() {
    return right;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateID<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code action} attribute
   */
  @Override
  protected BiFunction<L, R, State<D>> action() {
    return action;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withLeft(StateID<L> value) {
    if (this.left == value) return this;
    StateID<L> newValue = Objects.requireNonNull(value, "left");
    return new ImmutableJoin<>(newValue, this.right, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#right() right} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for right
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withRight(StateID<R> value) {
    if (this.right == value) return this;
    StateID<R> newValue = Objects.requireNonNull(value, "right");
    return new ImmutableJoin<>(this.left, newValue, this.destination, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withDestination(StateID<D> value) {
    if (this.destination == value) return this;
    StateID<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableJoin<>(this.left, this.right, newValue, this.action);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Join#action() action} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJoin<L, R, D> withAction(BiFunction<L, R, State<D>> value) {
    if (this.action == value) return this;
    BiFunction<L, R, State<D>> newValue = Objects.requireNonNull(value, "action");
    return new ImmutableJoin<>(this.left, this.right, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJoin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJoin<?, ?, ?>
        && equalTo((ImmutableJoin<?, ?, ?>) another);
  }

  private boolean equalTo(ImmutableJoin<?, ?, ?> another) {
    return left.equals(another.left)
        && right.equals(another.right)
        && destination.equals(another.destination)
        && action.equals(another.action);
  }

  /**
   * Computes a hash code from attributes: {@code left}, {@code right}, {@code destination}, {@code action}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    h += (h << 5) + right.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + action.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Join} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Join{"
        + "left=" + left
        + ", right=" + right
        + ", destination=" + destination
        + ", action=" + action
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SOURCES_LAZY_INIT_BIT = 0x1L;

  private transient Set<StateID<?>> sources;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Join#sources() sources} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code sources} attribute
   */
  @Override
  public Set<StateID<?>> sources() {
    if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SOURCES_LAZY_INIT_BIT) == 0) {
          this.sources = Objects.requireNonNull(super.sources(), "sources");
          lazyInitBitmap |= SOURCES_LAZY_INIT_BIT;
        }
      }
    }
    return sources;
  }

  /**
   * Creates an immutable copy of a {@link Join} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable Join instance
   */
  public static <L, R, D> ImmutableJoin<L, R, D> copyOf(Join<L, R, D> instance) {
    if (instance instanceof ImmutableJoin<?, ?, ?>) {
      return (ImmutableJoin<L, R, D>) instance;
    }
    return ImmutableJoin.<L, R, D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJoin ImmutableJoin}.
   * <pre>
   * ImmutableJoin.&amp;lt;L, R, D&amp;gt;builder()
   *    .left(de.flapdoodle.reverse.StateID&amp;lt;L&amp;gt;) // required {@link Join#left() left}
   *    .right(de.flapdoodle.reverse.StateID&amp;lt;R&amp;gt;) // required {@link Join#right() right}
   *    .destination(de.flapdoodle.reverse.StateID&amp;lt;D&amp;gt;) // required {@link Join#destination() destination}
   *    .action(function.BiFunction&amp;lt;L, R, de.flapdoodle.reverse.State&amp;lt;D&amp;gt;&amp;gt;) // required {@link Join#action() action}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param <D> generic parameter D
   * @return A new ImmutableJoin builder
   */
  public static <L, R, D> ImmutableJoin.Builder<L, R, D> builder() {
    return new ImmutableJoin.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableJoin ImmutableJoin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Join", generator = "Immutables")
  public static final class Builder<L, R, D> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private static final long INIT_BIT_RIGHT = 0x2L;
    private static final long INIT_BIT_DESTINATION = 0x4L;
    private static final long INIT_BIT_ACTION = 0x8L;
    private long initBits = 0xfL;

    private StateID<L> left;
    private StateID<R> right;
    private StateID<D> destination;
    private BiFunction<L, R, State<D>> action;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Join} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> from(Join<L, R, D> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      right(instance.right());
      destination(instance.destination());
      action(instance.action());
      return this;
    }

    /**
     * Initializes the value for the {@link Join#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> left(StateID<L> left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#right() right} attribute.
     * @param right The value for right 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> right(StateID<R> right) {
      this.right = Objects.requireNonNull(right, "right");
      initBits &= ~INIT_BIT_RIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> destination(StateID<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link Join#action() action} attribute.
     * @param action The value for action 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R, D> action(BiFunction<L, R, State<D>> action) {
      this.action = Objects.requireNonNull(action, "action");
      initBits &= ~INIT_BIT_ACTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJoin ImmutableJoin}.
     * @return An immutable instance of Join
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJoin<L, R, D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJoin<>(left, right, destination, action);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      if ((initBits & INIT_BIT_RIGHT) != 0) attributes.add("right");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_ACTION) != 0) attributes.add("action");
      return "Cannot build Join, some of required attributes are not set " + attributes;
    }
  }
}
