package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransitionsAsGraph.EdgeAndVertex}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEdgeAndVertex.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdgeAndVertex.of()}.
 */
@Generated(from = "TransitionsAsGraph.EdgeAndVertex", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEdgeAndVertex implements TransitionsAsGraph.EdgeAndVertex {
  private final StateID<?> start;
  private final Transition<?> edge;
  private final StateID<?> end;

  private ImmutableEdgeAndVertex(
      StateID<?> start,
      Transition<?> edge,
      StateID<?> end) {
    this.start = Objects.requireNonNull(start, "start");
    this.edge = Objects.requireNonNull(edge, "edge");
    this.end = Objects.requireNonNull(end, "end");
  }

  private ImmutableEdgeAndVertex(
      ImmutableEdgeAndVertex original,
      StateID<?> start,
      Transition<?> edge,
      StateID<?> end) {
    this.start = start;
    this.edge = edge;
    this.end = end;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public StateID<?> start() {
    return start;
  }

  /**
   * @return The value of the {@code edge} attribute
   */
  @Override
  public Transition<?> edge() {
    return edge;
  }

  /**
   * @return The value of the {@code end} attribute
   */
  @Override
  public StateID<?> end() {
    return end;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionsAsGraph.EdgeAndVertex#start() start} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdgeAndVertex withStart(StateID<?> value) {
    if (this.start == value) return this;
    StateID<?> newValue = Objects.requireNonNull(value, "start");
    return new ImmutableEdgeAndVertex(this, newValue, this.edge, this.end);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionsAsGraph.EdgeAndVertex#edge() edge} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for edge
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdgeAndVertex withEdge(Transition<?> value) {
    if (this.edge == value) return this;
    Transition<?> newValue = Objects.requireNonNull(value, "edge");
    return new ImmutableEdgeAndVertex(this, this.start, newValue, this.end);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionsAsGraph.EdgeAndVertex#end() end} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for end
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdgeAndVertex withEnd(StateID<?> value) {
    if (this.end == value) return this;
    StateID<?> newValue = Objects.requireNonNull(value, "end");
    return new ImmutableEdgeAndVertex(this, this.start, this.edge, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdgeAndVertex} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdgeAndVertex
        && equalTo((ImmutableEdgeAndVertex) another);
  }

  private boolean equalTo(ImmutableEdgeAndVertex another) {
    return start.equals(another.start)
        && edge.equals(another.edge)
        && end.equals(another.end);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code edge}, {@code end}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start.hashCode();
    h += (h << 5) + edge.hashCode();
    h += (h << 5) + end.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EdgeAndVertex} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EdgeAndVertex{"
        + "start=" + start
        + ", edge=" + edge
        + ", end=" + end
        + "}";
  }

  /**
   * Construct a new immutable {@code EdgeAndVertex} instance.
   * @param start The value for the {@code start} attribute
   * @param edge The value for the {@code edge} attribute
   * @param end The value for the {@code end} attribute
   * @return An immutable EdgeAndVertex instance
   */
  public static ImmutableEdgeAndVertex of(StateID<?> start, Transition<?> edge, StateID<?> end) {
    return new ImmutableEdgeAndVertex(start, edge, end);
  }

  /**
   * Creates an immutable copy of a {@link TransitionsAsGraph.EdgeAndVertex} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EdgeAndVertex instance
   */
  public static ImmutableEdgeAndVertex copyOf(TransitionsAsGraph.EdgeAndVertex instance) {
    if (instance instanceof ImmutableEdgeAndVertex) {
      return (ImmutableEdgeAndVertex) instance;
    }
    return ImmutableEdgeAndVertex.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEdgeAndVertex ImmutableEdgeAndVertex}.
   * <pre>
   * ImmutableEdgeAndVertex.builder()
   *    .start(de.flapdoodle.reverse.StateID&amp;lt;?&amp;gt;) // required {@link TransitionsAsGraph.EdgeAndVertex#start() start}
   *    .edge(de.flapdoodle.reverse.Transition&amp;lt;?&amp;gt;) // required {@link TransitionsAsGraph.EdgeAndVertex#edge() edge}
   *    .end(de.flapdoodle.reverse.StateID&amp;lt;?&amp;gt;) // required {@link TransitionsAsGraph.EdgeAndVertex#end() end}
   *    .build();
   * </pre>
   * @return A new ImmutableEdgeAndVertex builder
   */
  public static ImmutableEdgeAndVertex.Builder builder() {
    return new ImmutableEdgeAndVertex.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEdgeAndVertex ImmutableEdgeAndVertex}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransitionsAsGraph.EdgeAndVertex", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_EDGE = 0x2L;
    private static final long INIT_BIT_END = 0x4L;
    private long initBits = 0x7L;

    private StateID<?> start;
    private Transition<?> edge;
    private StateID<?> end;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EdgeAndVertex} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TransitionsAsGraph.EdgeAndVertex instance) {
      Objects.requireNonNull(instance, "instance");
      start(instance.start());
      edge(instance.edge());
      end(instance.end());
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionsAsGraph.EdgeAndVertex#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder start(StateID<?> start) {
      this.start = Objects.requireNonNull(start, "start");
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionsAsGraph.EdgeAndVertex#edge() edge} attribute.
     * @param edge The value for edge 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder edge(Transition<?> edge) {
      this.edge = Objects.requireNonNull(edge, "edge");
      initBits &= ~INIT_BIT_EDGE;
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionsAsGraph.EdgeAndVertex#end() end} attribute.
     * @param end The value for end 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder end(StateID<?> end) {
      this.end = Objects.requireNonNull(end, "end");
      initBits &= ~INIT_BIT_END;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEdgeAndVertex ImmutableEdgeAndVertex}.
     * @return An immutable instance of EdgeAndVertex
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdgeAndVertex build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEdgeAndVertex(null, start, edge, end);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_EDGE) != 0) attributes.add("edge");
      if ((initBits & INIT_BIT_END) != 0) attributes.add("end");
      return "Cannot build EdgeAndVertex, some of required attributes are not set " + attributes;
    }
  }
}
