/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.edges.ImmutableStart;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Start<D>
implements Transition<D> {
    @Override
    public abstract StateID<D> destination();

    protected abstract Supplier<State<D>> action();

    @Override
    @Value.Lazy
    public Set<StateID<?>> sources() {
        return Collections.emptySet();
    }

    @Override
    @Value.Auxiliary
    public State<D> result(StateLookup lookup) {
        return this.action().get();
    }

    public static <D> Start<D> of(StateID<D> dest, Supplier<State<D>> action) {
        return ImmutableStart.builder().destination(dest).action(action).build();
    }

    public static <D> WithDestination<D> to(StateID<D> dest) {
        return new WithDestination(dest);
    }

    public static <D> WithDestination<D> to(Class<D> destType) {
        return Start.to(StateID.of(destType));
    }

    public static class WithDestination<T> {
        private final StateID<T> state;

        private WithDestination(StateID<T> state) {
            this.state = state;
        }

        public Start<T> initializedWith(T value) {
            return this.with(() -> State.of(value, new TearDown[0]));
        }

        public Start<T> providedBy(Supplier<T> valueSupplier) {
            return this.with(() -> State.of(valueSupplier.get(), new TearDown[0]));
        }

        public Start<T> with(Supplier<State<T>> supplier) {
            return Start.of(this.state, supplier);
        }
    }
}

