/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.edges;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.edges.ImmutableJoin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Join<L, R, D>
implements Transition<D> {
    public abstract StateID<L> left();

    public abstract StateID<R> right();

    @Override
    public abstract StateID<D> destination();

    protected abstract BiFunction<L, R, State<D>> action();

    @Override
    @Value.Lazy
    public Set<StateID<?>> sources() {
        return new HashSet(Arrays.asList(this.left(), this.right()));
    }

    @Override
    @Value.Auxiliary
    public State<D> result(StateLookup lookup) {
        return this.action().apply(lookup.of(this.left()), lookup.of(this.right()));
    }

    public static <L, R, D> Join<L, R, D> of(StateID<L> left, StateID<R> right, StateID<D> dest, BiFunction<L, R, State<D>> action) {
        return ImmutableJoin.builder().left(left).right(right).destination(dest).action(action).build();
    }

    public static <L> WithLeft<L> given(StateID<L> left) {
        return new WithLeft(left);
    }

    public static <L> WithLeft<L> given(Class<L> sourceType) {
        return Join.given(StateID.of(sourceType));
    }

    public static class WithDestination<L, R, D> {
        private final StateID<L> left;
        private final StateID<R> right;
        private final StateID<D> destination;

        public WithDestination(StateID<L> left, StateID<R> right, StateID<D> destination) {
            this.left = left;
            this.right = right;
            this.destination = destination;
        }

        public Join<L, R, D> deriveBy(BiFunction<L, R, D> action) {
            return this.with(action.andThen(x$0 -> State.of(x$0, new TearDown[0])));
        }

        public Join<L, R, D> with(BiFunction<L, R, State<D>> action) {
            return Join.of(this.left, this.right, this.destination, action);
        }
    }

    public static class WithSources<L, R> {
        private final StateID<L> left;
        private final StateID<R> right;

        public WithSources(StateID<L> left, StateID<R> right) {
            this.left = left;
            this.right = right;
        }

        public <D> WithDestination<L, R, D> state(StateID<D> destination) {
            return new WithDestination<L, R, D>(this.left, this.right, destination);
        }

        public <D> WithDestination<L, R, D> state(Class<D> destination) {
            return this.state(StateID.of(destination));
        }
    }

    public static class WithLeft<L> {
        private final StateID<L> left;

        private WithLeft(StateID<L> left) {
            this.left = left;
        }

        public <R> WithSources<L, R> and(StateID<R> right) {
            return new WithSources<L, R>(this.left, right);
        }

        public <R> WithSources<L, R> and(Class<R> right) {
            return this.and(StateID.of(right));
        }
    }
}

