/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.graph.GraphAsDot;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.reverse.ImmutableEdgeAndVertex;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.edges.Derive;
import de.flapdoodle.reverse.edges.Join;
import de.flapdoodle.reverse.edges.Start;
import de.flapdoodle.reverse.types.TypeNames;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.immutables.value.Value;
import org.jgrapht.graph.DefaultDirectedGraph;

public abstract class TransitionsAsGraph {
    public static DefaultDirectedGraph<StateID<?>, EdgeAndVertex> asGraph(List<? extends Transition<?>> all) {
        return TransitionsAsGraph.asGraph(all, false);
    }

    public static DefaultDirectedGraph<StateID<?>, EdgeAndVertex> asGraphIncludingStartAndEnd(List<? extends Transition<?>> all) {
        return TransitionsAsGraph.asGraph(all, true);
    }

    private static DefaultDirectedGraph<StateID<?>, EdgeAndVertex> asGraph(List<? extends Transition<?>> all, boolean addEmptyVertex) {
        Supplier directedGraph = Graphs.graphBuilder((Supplier)Graphs.directedGraph(EdgeAndVertex.class));
        return (DefaultDirectedGraph)Graphs.with((Supplier)directedGraph).build(graph -> {
            AtomicInteger voidCounter = new AtomicInteger();
            all.forEach(edge -> {
                graph.addVertex(edge.destination());
                edge.sources().forEach(source -> {
                    graph.addVertex(source);
                    graph.addEdge(source, edge.destination(), (Object)EdgeAndVertex.of(source, edge, edge.destination()));
                });
                if (addEmptyVertex && edge.sources().isEmpty()) {
                    StateID<Void> start = StateID.of("start_" + voidCounter.incrementAndGet(), Void.class);
                    graph.addVertex(start);
                    graph.addEdge(start, edge.destination(), (Object)EdgeAndVertex.of(start, edge, edge.destination()));
                }
            });
        });
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<StateID<?>, EdgeAndVertex> graph) {
        return TransitionsAsGraph.edgeGraphAsDot(label, graph, TransitionsAsGraph::transitionAsLabel, TransitionsAsGraph::stateAsLabel);
    }

    public static String edgeGraphAsDot(String label, DefaultDirectedGraph<StateID<?>, EdgeAndVertex> graph, Function<Transition<?>, String> transitionAsLabel, Function<StateID<?>, String> stateIdAsLabel) {
        return GraphAsDot.builder(TransitionsAsGraph::asLabel).label(label).edgeAttributes((a, b) -> {
            Transition<?> route = ((EdgeAndVertex)graph.getEdge(a, b)).edge();
            String routeLabel = (String)transitionAsLabel.apply(route);
            return TransitionsAsGraph.asMap("label", routeLabel);
        }).nodeAttributes(t -> {
            if (t.type() == Void.class) {
                return TransitionsAsGraph.asMap("shape", "circle", "label", "");
            }
            String nodeLabel = (String)stateIdAsLabel.apply((StateID<?>)t);
            return TransitionsAsGraph.asMap("shape", "rectangle", "label", nodeLabel);
        }).build().asDot(graph);
    }

    private static String stateAsLabel(StateID<?> t) {
        return t.name() + ":" + TypeNames.typeName(t.type());
    }

    private static String transitionAsLabel(Transition<?> route) {
        if (route instanceof Start) {
            return TypeNames.typeName(Start.class);
        }
        if (route instanceof Derive) {
            return TypeNames.typeName(Derive.class);
        }
        if (route instanceof Join) {
            return TypeNames.typeName(Join.class);
        }
        return TypeNames.typeName(route.getClass());
    }

    private static Map<String, String> asMap(String ... keyValues) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("parameter not modulo of 2");
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            ret.put(keyValues[i], keyValues[i + 1]);
        }
        return ret;
    }

    private static String asLabel(StateID<?> type) {
        return (type.name().isEmpty() ? "<empty>" : type.name()) + ":" + type.type().toString();
    }

    @Value.Immutable
    public static interface EdgeAndVertex {
        @Value.Parameter
        public StateID<?> start();

        @Value.Parameter
        public Transition<?> edge();

        @Value.Parameter
        public StateID<?> end();

        public static EdgeAndVertex of(StateID<?> start, Transition<?> route, StateID<?> end) {
            return ImmutableEdgeAndVertex.of(start, route, end);
        }
    }
}

