/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.ImmutableSimple;
import de.flapdoodle.reverse.ImmutableStateListener;
import de.flapdoodle.reverse.ImmutableTypedListener;
import de.flapdoodle.reverse.InitOnStateReached;
import de.flapdoodle.reverse.InitOnStateTearDown;
import de.flapdoodle.reverse.StateID;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.immutables.value.Value;

public interface InitListener
extends InitOnStateReached,
InitOnStateTearDown {
    public static TypedListener.Builder typedBuilder() {
        return ImmutableTypedListener.builder();
    }

    public static ImmutableSimple.Builder builder() {
        return ImmutableSimple.builder();
    }

    public static InitListener of(BiConsumer<StateID<?>, Object> onStateReached, BiConsumer<StateID<?>, Object> onTearDown) {
        return InitListener.builder().onStateReached(onStateReached).onTearDown(onTearDown).build();
    }

    @Value.Immutable
    public static interface StateListener<T> {
        @Value.Parameter
        public StateID<T> type();

        @Value.Parameter
        public Consumer<T> listener();

        public static <T> StateListener<T> of(StateID<T> type, Consumer<T> listener) {
            return ImmutableStateListener.of(type, listener);
        }
    }

    @Value.Immutable
    public static abstract class TypedListener
    implements InitListener {
        protected abstract List<StateListener<?>> stateReachedListener();

        protected abstract List<StateListener<?>> stateTearDownListener();

        @Value.Auxiliary
        @Value.Lazy
        protected Map<StateID<?>, Consumer<?>> stateReachedListenerAsMap() {
            return this.stateReachedListener().stream().collect(Collectors.toMap(l -> l.type(), l -> l.listener()));
        }

        @Value.Auxiliary
        @Value.Lazy
        protected Map<StateID<?>, Consumer<?>> stateTearDownListenerAsMap() {
            return this.stateTearDownListener().stream().collect(Collectors.toMap(l -> l.type(), l -> l.listener()));
        }

        @Override
        public <T> void onStateReached(StateID<T> state, T value) {
            Optional.ofNullable(this.stateReachedListenerAsMap().get(state)).ifPresent(c -> c.accept(value));
        }

        @Override
        public <T> void onStateTearDown(StateID<T> state, T value) {
            Optional.ofNullable(this.stateTearDownListenerAsMap().get(state)).ifPresent(c -> c.accept(value));
        }

        public static interface Builder {
            public Builder addStateReachedListener(StateListener<?> var1);

            public Builder addStateTearDownListener(StateListener<?> var1);

            default public <T> Builder onStateReached(StateID<T> type, Consumer<T> listener) {
                return this.addStateReachedListener(StateListener.of(type, listener));
            }

            default public <T> Builder onStateTearDown(StateID<T> type, Consumer<T> listener) {
                return this.addStateTearDownListener(StateListener.of(type, listener));
            }

            public InitListener build();
        }
    }

    @Value.Immutable
    public static abstract class Simple
    implements InitListener {
        protected abstract Optional<BiConsumer<StateID<?>, Object>> onStateReached();

        protected abstract Optional<BiConsumer<StateID<?>, Object>> onTearDown();

        @Override
        public <T> void onStateReached(StateID<T> state, T value) {
            this.onStateReached().ifPresent(l -> l.accept(state, value));
        }

        @Override
        public <T> void onStateTearDown(StateID<T> state, T value) {
            this.onTearDown().ifPresent(l -> l.accept(state, value));
        }
    }
}

