/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.graph.VerticesAndEdges;
import de.flapdoodle.reverse.InitListener;
import de.flapdoodle.reverse.MapBasedStateLookup;
import de.flapdoodle.reverse.NamedTypeAndState;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDownException;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionsAsGraph;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;

public class InitLike {
    private static final String JAVA_LANG_PACKAGE = "java.lang.";
    private final Context context;

    private InitLike(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> edgesAsGraph, Map<StateID<?>, List<Transition<?>>> routeByDestination) {
        this.context = new Context(edgesAsGraph, routeByDestination);
    }

    public <D> ReachedState<D> init(StateID<D> destination, InitListener ... listener) {
        return this.context.init(new LinkedHashMap(), destination, Collections.unmodifiableList(Arrays.asList(listener)));
    }

    private static Map<StateID<?>, State<?>> resolve(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph, Map<StateID<?>, List<Transition<?>>> routeByDestination, Set<StateID<?>> destinations, StateLookup stateOfType, List<InitListener> initListener) {
        LinkedHashMap ret = new LinkedHashMap();
        for (StateID<?> destination : destinations) {
            ret.put(destination, InitLike.resolve(routesAsGraph, routeByDestination, destination, stateOfType, initListener));
        }
        return ret;
    }

    private static <D> State<D> resolve(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph, Map<StateID<?>, List<Transition<?>>> routeByDestination, StateID<D> destination, StateLookup stateOfType, List<InitListener> initListener) {
        Function<StateLookup, State<D>> resolver = InitLike.resolverOf(routesAsGraph, routeByDestination, destination);
        State state = resolver.apply(stateOfType);
        initListener.forEach(listener -> listener.onStateReached(destination, state.value()));
        return state;
    }

    private static <D> Function<StateLookup, State<D>> resolverOf(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph, Map<StateID<?>, List<Transition<?>>> routeByDestination, StateID<D> destination) {
        Preconditions.checkArgument((boolean)routesAsGraph.containsVertex(destination), (String)"routes does not contain %s", (Object[])new Object[]{InitLike.asMessage(destination)});
        Transition<D> route = InitLike.routeOf(routeByDestination, destination);
        return route::result;
    }

    private static Collection<VerticesAndEdges<StateID<?>, TransitionsAsGraph.EdgeAndVertex>> dependenciesOf(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph, StateID<?> destination) {
        DefaultDirectedGraph filtered = Graphs.filter(routesAsGraph, v -> v.equals(destination) || InitLike.isDependencyOf(routesAsGraph, v, destination));
        Collection roots = Graphs.rootsOf((DefaultDirectedGraph)filtered);
        return roots;
    }

    private static boolean isDependencyOf(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph, StateID<?> source, StateID<?> destination) {
        GraphPath ret = DijkstraShortestPath.findPathBetween(routesAsGraph, source, destination);
        return ret != null && !ret.getEdgeList().isEmpty();
    }

    private static void printGraphAsDot(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> routesAsGraph) {
        String dot = TransitionsAsGraph.edgeGraphAsDot("init", routesAsGraph);
        System.out.println("---------------------");
        System.out.println(dot);
        System.out.println("---------------------");
    }

    private static <D> Transition<D> routeOf(Map<StateID<?>, List<Transition<?>>> routeByDestination, StateID<D> destination) {
        List<Transition<?>> routeForThisDestination = routeByDestination.get(destination);
        Preconditions.checkArgument((routeForThisDestination != null ? 1 : 0) != 0, (String)"found no route to %s", (Object[])new Object[]{destination});
        Preconditions.checkArgument((!routeForThisDestination.isEmpty() ? 1 : 0) != 0, (String)"found no route to %s", (Object[])new Object[]{destination});
        Preconditions.checkArgument((routeForThisDestination.size() == 1 ? 1 : 0) != 0, (String)"found more than one route to %s: %s", (Object[])new Object[]{destination, routeForThisDestination});
        return routeForThisDestination.get(0);
    }

    private static void tearDown(List<Collection<NamedTypeAndState<?>>> initializedStates, List<InitListener> initListener) {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        initializedStates.forEach(stateSet -> stateSet.forEach(typeAndState -> {
            InitLike.notifyListener(initListener, typeAndState);
            try {
                InitLike.tearDown(typeAndState.state());
            }
            catch (RuntimeException rx) {
                exceptions.add(rx);
            }
        }));
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new TearDownException("tearDown errors", (RuntimeException)exceptions.get(0));
            }
            throw new TearDownException("tearDown errors", exceptions);
        }
    }

    private static Collection<NamedTypeAndState<?>> asNamedTypeAndState(Map<StateID<?>, State<?>> newStatesAsMap) {
        return newStatesAsMap.entrySet().stream().map(InitLike::namedTypeAndStateOf).collect(Collectors.toList());
    }

    private static NamedTypeAndState<?> namedTypeAndStateOf(Map.Entry<StateID<?>, State<?>> e) {
        return NamedTypeAndState.of(e.getKey(), e.getValue());
    }

    private static <T> void notifyListener(List<InitListener> initListener, NamedTypeAndState<T> typeAndState) {
        initListener.forEach(listener -> listener.onStateTearDown(typeAndState.type(), typeAndState.state().value()));
    }

    private static <T> Set<T> filterNotIn(Set<T> existing, Set<T> toFilter) {
        return toFilter.stream().filter(t -> !existing.contains(t)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <D> void tearDown(State<D> state) {
        state.onTearDown().ifPresent(t -> t.onTearDown(state.value()));
    }

    public static InitLike with(List<? extends Transition<?>> src) {
        ArrayList routes = new ArrayList(src);
        DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> edgesAsGraph = TransitionsAsGraph.asGraph(routes);
        List loops = Graphs.loopsOf(edgesAsGraph);
        Preconditions.checkArgument((boolean)loops.isEmpty(), (String)"loops are not supported: %s", (Object[])new Object[]{Preconditions.lazy(() -> InitLike.asMessage(loops))});
        Map<StateID<?>, List<Transition<?>>> routeByDestination = routes.stream().collect(Collectors.groupingBy(Transition::destination));
        return new InitLike(edgesAsGraph, routeByDestination);
    }

    private static String asMessage(List<? extends Loop<StateID<?>, ?>> loops) {
        return loops.stream().map(InitLike::asMessage).reduce((l, r) -> l + "\n" + r).orElse("");
    }

    private static String asMessage(Loop<StateID<?>, ?> loop) {
        return loop.vertexSet().stream().map(InitLike::asMessage).reduce((l, r) -> l + "->" + r).get();
    }

    private static String asMessage(Collection<StateID<?>> types) {
        return types.stream().map(InitLike::asMessage).reduce((l, r) -> l + ", " + r).get();
    }

    private static String asMessage(StateID<?> type) {
        return "NamedType(" + (type.name().isEmpty() ? InitLike.typeAsMessage(type.type()) : type.name() + ":" + InitLike.typeAsMessage(type.type())) + ")";
    }

    private static String typeAsMessage(Type type) {
        return type.getTypeName().startsWith(JAVA_LANG_PACKAGE) ? type.getTypeName().substring(JAVA_LANG_PACKAGE.length()) : type.getTypeName();
    }

    public static class ReachedState<D>
    implements AutoCloseable {
        private final State<D> state;
        private final List<Collection<NamedTypeAndState<?>>> initializedStates;
        private final Map<StateID<?>, State<?>> stateMap;
        private final Context context;
        private final List<InitListener> initListener;

        private ReachedState(Context context, List<Collection<NamedTypeAndState<?>>> initializedStates, Map<StateID<?>, State<?>> stateMap, State<D> state, List<InitListener> initListener) {
            this.context = context;
            this.state = state;
            this.initListener = (List)Preconditions.checkNotNull(initListener, (String)"initListener is null", (Object[])new Object[0]);
            this.stateMap = new LinkedHashMap(stateMap);
            this.initializedStates = new ArrayList(initializedStates);
        }

        public <T> ReachedState<T> init(StateID<T> destination) {
            return this.context.init(this.stateMap, destination, this.initListener);
        }

        @Override
        public void close() {
            InitLike.tearDown(this.initializedStates, this.initListener);
        }

        public D current() {
            return this.state.value();
        }

        public State<D> asState() {
            return State.builder(this.current()).onTearDown(current -> this.close()).build();
        }
    }

    private static class Context {
        private final DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> edgesAsGraph;
        private final Map<StateID<?>, List<Transition<?>>> routeByDestination;

        private Context(DefaultDirectedGraph<StateID<?>, TransitionsAsGraph.EdgeAndVertex> edgesAsGraph, Map<StateID<?>, List<Transition<?>>> routeByDestination) {
            this.edgesAsGraph = edgesAsGraph;
            this.routeByDestination = routeByDestination;
        }

        private <D> ReachedState<D> init(Map<StateID<?>, State<?>> currentStateMap, StateID<D> destination, List<InitListener> initListener) {
            Preconditions.checkArgument((!currentStateMap.containsKey(destination) ? 1 : 0) != 0, (String)"state %s already initialized", (Object[])new Object[]{InitLike.asMessage(destination)});
            Preconditions.checkArgument((boolean)this.edgesAsGraph.containsVertex(destination), (String)"state %s is not part of this init process", (Object[])new Object[]{InitLike.asMessage(destination)});
            LinkedHashMap stateMap = new LinkedHashMap(currentStateMap);
            ArrayList<Collection> initializedStates = new ArrayList<Collection>();
            Collection dependencies = InitLike.dependenciesOf(this.edgesAsGraph, destination);
            for (VerticesAndEdges set : dependencies) {
                Set needInitialization = InitLike.filterNotIn(stateMap.keySet(), set.vertices());
                try {
                    Map newStatesAsMap = InitLike.resolve(this.edgesAsGraph, this.routeByDestination, needInitialization, new MapBasedStateLookup(stateMap), (List<InitListener>)initListener);
                    if (newStatesAsMap.isEmpty()) continue;
                    initializedStates.add(InitLike.asNamedTypeAndState(newStatesAsMap));
                    stateMap.putAll(newStatesAsMap);
                }
                catch (RuntimeException ex) {
                    InitLike.tearDown(initializedStates, initListener);
                    throw new RuntimeException("error on transition to " + InitLike.asMessage(needInitialization) + ", rollback", ex);
                }
            }
            Collections.reverse(initializedStates);
            return new ReachedState(this, initializedStates, stateMap, Context.stateOfMap(stateMap, destination), initListener);
        }

        private static <D> State<D> stateOfMap(Map<StateID<?>, State<?>> stateMap, StateID<D> destination) {
            return stateMap.get(destination);
        }
    }
}

