/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava.monads;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import de.flapdoodle.guava.monads.Failure;
import de.flapdoodle.guava.monads.Success;

public abstract class TryX<T> {
    protected TryX() {
    }

    public static <U> TryX<U> ofFailable(Supplier<U> f) {
        Preconditions.checkNotNull(f);
        try {
            Object y = f.get();
            return TryX.successful(y);
        }
        catch (RuntimeException t) {
            return TryX.failure(t);
        }
    }

    public abstract <U> TryX<U> map(Function<? super T, ? extends U> var1);

    public abstract <U> TryX<U> flatMap(Function<? super T, TryX<U>> var1);

    public abstract T recover(Function<? super RuntimeException, T> var1);

    public abstract TryX<T> recoverWith(Function<? super RuntimeException, TryX<T>> var1);

    public abstract T orElse(T var1);

    public abstract TryX<T> orElseTry(Supplier<T> var1);

    public abstract T get();

    public abstract boolean isSuccess();

    public abstract <F> TryX<T> onFailure(Function<RuntimeException, F> var1);

    public static <U> TryX<U> failure(RuntimeException e) {
        return new Failure(e);
    }

    public static <U> TryX<U> successful(U x) {
        return new Success<U>(x);
    }
}

