/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava.monads;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import de.flapdoodle.guava.monads.TryX;

class Success<T>
extends TryX<T> {
    private final T value;

    public Success(T value) {
        this.value = value;
    }

    @Override
    public <U> TryX<U> flatMap(Function<? super T, TryX<U>> f) {
        Preconditions.checkNotNull(f);
        try {
            return (TryX)f.apply(this.value);
        }
        catch (RuntimeException t) {
            return TryX.failure(t);
        }
    }

    @Override
    public T recover(Function<? super RuntimeException, T> f) {
        Preconditions.checkNotNull(f);
        return this.value;
    }

    @Override
    public TryX<T> recoverWith(Function<? super RuntimeException, TryX<T>> f) {
        Preconditions.checkNotNull(f);
        return this;
    }

    @Override
    public T orElse(T value) {
        return this.value;
    }

    @Override
    public TryX<T> orElseTry(Supplier<T> f) {
        Preconditions.checkNotNull(f);
        return this;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public <U> TryX<U> map(Function<? super T, ? extends U> f) {
        Preconditions.checkNotNull(f);
        try {
            return new Success<Object>(f.apply(this.value));
        }
        catch (RuntimeException t) {
            return TryX.failure(t);
        }
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public <F> TryX<T> onFailure(Function<RuntimeException, F> f) {
        return this;
    }
}

