/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava.monads;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import de.flapdoodle.guava.monads.TryX;

class Failure<T>
extends TryX<T> {
    private final RuntimeException e;

    Failure(RuntimeException e) {
        this.e = e;
    }

    @Override
    public <U> TryX<U> map(Function<? super T, ? extends U> f) {
        Preconditions.checkNotNull(f);
        return TryX.failure(this.e);
    }

    @Override
    public <U> TryX<U> flatMap(Function<? super T, TryX<U>> f) {
        Preconditions.checkNotNull(f);
        return TryX.failure(this.e);
    }

    @Override
    public T recover(Function<? super RuntimeException, T> f) {
        Preconditions.checkNotNull(f);
        return (T)f.apply((Object)this.e);
    }

    @Override
    public TryX<T> recoverWith(Function<? super RuntimeException, TryX<T>> f) {
        Preconditions.checkNotNull(f);
        try {
            return (TryX)f.apply((Object)this.e);
        }
        catch (RuntimeException t) {
            return TryX.failure(t);
        }
    }

    @Override
    public T orElse(T value) {
        return value;
    }

    @Override
    public TryX<T> orElseTry(Supplier<T> f) {
        Preconditions.checkNotNull(f);
        return TryX.ofFailable(f);
    }

    @Override
    public T get() {
        throw this.e;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public <F> TryX<T> onFailure(Function<RuntimeException, F> f) {
        f.apply((Object)this.e);
        return this;
    }
}

