/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava.maps;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class FluentMap<K, V> {
    private final Map<K, V> map;

    public FluentMap(Map<K, V> source) {
        this.map = source;
    }

    public <NV> FluentMap<K, NV> transformValues(Function<? super V, NV> function) {
        return FluentMap.from(Maps.transformValues(this.map, function));
    }

    public FluentMap<K, V> filterKeys(Predicate<? super K> keyPredicate) {
        return FluentMap.from(Maps.filterKeys(this.map, keyPredicate));
    }

    public FluentMap<K, V> filterValues(Predicate<? super V> valuePredicate) {
        return FluentMap.from(Maps.filterValues(this.map, valuePredicate));
    }

    public <NK> FluentMap<NK, Collection<V>> indexValue(Function<? super V, NK> function) {
        return FluentMap.from(FluentIterable.from(this.map.values()).index(function).asMap());
    }

    public FluentMap<V, K> inverse() {
        return FluentMap.from(FluentIterable.from(this.map.keySet()).uniqueIndex(new Function<K, V>(){

            public V apply(K k) {
                return FluentMap.this.map.get(k);
            }
        }));
    }

    public <K2, V2> FluentMap<K, V2> transformValues(final Map<V, V2> other) {
        return this.filterValues(new Predicate<V>(){

            public boolean apply(V v) {
                return other.containsKey(v);
            }
        }).transformValues(new Function<V, V2>(){

            public V2 apply(V v) {
                return other.get(v);
            }
        });
    }

    public ImmutableMap<K, V> build() {
        return ImmutableMap.copyOf(this.map);
    }

    public static <K, V> FluentMap<K, V> from(Map<K, V> source) {
        return new FluentMap<K, V>(source);
    }
}

