/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import de.flapdoodle.guava.Foldleft;
import de.flapdoodle.guava.Folds;
import de.flapdoodle.guava.InlineCallToReplaceDeprecatedFunction;
import de.flapdoodle.guava.MapCreator;
import de.flapdoodle.guava.MapCreators;
import de.flapdoodle.guava.Pair;
import de.flapdoodle.guava.Partition;
import de.flapdoodle.guava.Types;
import de.flapdoodle.guava.Varargs;
import de.flapdoodle.guava.functions.BiFunction;
import de.flapdoodle.guava.functions.NoTransformation;
import de.flapdoodle.guava.functions.ValueToCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Transformations {
    private Transformations() {
    }

    public static <T> Collection<T> emptyIfNull(Collection<T> source) {
        return Types.defaultIfNull(source, Collections.emptyList());
    }

    public static <S, D, C extends Collection<? extends D>> ImmutableList<? extends D> flatmap(Collection<? extends S> source, Function<? super S, C> transformation) {
        return Folds.foldLeft(source, Folds.asListFold(transformation), ImmutableList.of());
    }

    public static <S, D, C extends Iterable<? extends D>> Iterable<? extends D> flatmap(Iterable<? extends S> source, Function<? super S, C> transformation) {
        return FluentIterable.from(source).transformAndConcat(transformation);
    }

    public static <T> ImmutableList<? extends T> flatmap(Collection<? extends Collection<? extends T>> collections) {
        return Transformations.flatmap(collections, new Function<Collection<? extends T>, Collection<? extends T>>(){

            public Collection<? extends T> apply(Collection<? extends T> input) {
                return input;
            }
        });
    }

    public static <T> ImmutableList<? extends T> flatmap(Collection<? extends T> collection, Collection<? extends T> otherCollection, Collection<? extends T> ... collections) {
        return Transformations.flatmap(Varargs.asCollection(collection, otherCollection, collections));
    }

    public static <K, V> Map<K, V> map(Iterable<Pair<K, V>> pairs) {
        return Transformations.map(pairs, new Pair.PairToKey(), new Pair.PairToValue());
    }

    public static <K, T> Map<K, T> map(Iterable<T> collection, Function<? super T, K> keytransformation) {
        return Transformations.map(collection, keytransformation, new NoTransformation());
    }

    public static <K, V, T> Map<K, V> map(Iterable<T> collection, Function<? super T, K> keyTransformation, Function<? super T, V> valueTransformation) {
        return Transformations.map(MapCreators.hashMap(), collection, keyTransformation, valueTransformation);
    }

    public static <K, V, T> Map<K, V> map(Iterable<T> collection, Function<? super T, K> keyTransformation, Foldleft<? super T, V> valueFold) {
        return Transformations.map(MapCreators.hashMap(), collection, keyTransformation, valueFold);
    }

    public static <K extends Enum<K>, T> EnumMap<K, T> map(Class<K> enumType, Iterable<T> collection, Function<? super T, K> keytransformation) {
        return Transformations.map(enumType, collection, keytransformation, new NoTransformation());
    }

    public static <K extends Enum<K>, V, T> EnumMap<K, V> map(Class<K> enumType, Iterable<T> collection, Function<? super T, K> keyTransformation, Function<? super T, V> valueTransformation) {
        return Transformations.map(MapCreators.enumMap(enumType), collection, keyTransformation, valueTransformation);
    }

    public static <K extends Enum<K>, V, T> EnumMap<K, V> map(Class<K> enumType, Iterable<T> collection, Function<? super T, K> keyTransformation, Foldleft<? super T, V> valueFold) {
        return Transformations.map(MapCreators.enumMap(enumType), collection, keyTransformation, valueFold);
    }

    private static <K, V, T, M extends Map<K, V>> M map(MapCreator<K, V, M> mapCreator, Iterable<T> collection, Function<? super T, K> keyTransformation, Function<? super T, V> valueTransformation) {
        return Transformations.map(mapCreator, collection, keyTransformation, new Folds.ValueFromLeftIllegalFold<T, V>(valueTransformation));
    }

    private static <K, V, T, M extends Map<K, V>> M map(MapCreator<K, V, M> mapCreator, Iterable<T> collection, Function<? super T, K> keyTransformation, Foldleft<? super T, V> valueFold) {
        M map = mapCreator.newInstance();
        for (T value : collection) {
            Object key = keyTransformation.apply(value);
            map.put((Object)key, valueFold.apply(map.get(key), value));
        }
        return map;
    }

    public static <A, B> Predicate<B> map(final Predicate<A> predicate, final Function<B, A> transformation) {
        return new Predicate<B>(){

            public boolean apply(B input) {
                return predicate.apply(transformation.apply(input));
            }
        };
    }

    public static <T> Iterable<T> firstOf(Iterable<T> collections, int items) {
        Preconditions.checkArgument((items > 0 ? 1 : 0) != 0, (Object)"items must be bigger then 0");
        return FluentIterable.from(collections).limit(items);
    }

    public static <T> Collection<T> firstOf(Collection<T> collections, int items) {
        Preconditions.checkArgument((items > 0 ? 1 : 0) != 0, (Object)"items must be bigger then 0");
        return Lists.newArrayList(Transformations.firstOf(collections, items));
    }

    public static <T> Optional<T> firstOf(Collection<T> collections) {
        if (collections.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(collections.iterator().next());
    }

    public static <T> Partition<T> partition(Collection<T> collection, Predicate<? super T> filter) {
        return new Partition(Collections2.filter(collection, filter), Collections2.filter(collection, (Predicate)Predicates.not(filter)));
    }

    public static <T> Partition<T> split(Collection<T> source, int index) {
        ImmutableList asList = ImmutableList.copyOf(source);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index < 0");
        Preconditions.checkArgument((index <= asList.size() ? 1 : 0) != 0, (Object)"index > size");
        return new Partition(asList.subList(0, index), asList.subList(index, asList.size()));
    }

    @Deprecated
    @InlineCallToReplaceDeprecatedFunction
    public static <A, B> ImmutableList<Pair<A, B>> zip(Iterable<A> a, Iterable<B> b) {
        return Transformations.zip(a.iterator(), b.iterator());
    }

    @Deprecated
    @InlineCallToReplaceDeprecatedFunction
    public static <A, B> ImmutableList<Pair<A, B>> zip(Iterator<A> a, Iterator<B> b) {
        return ImmutableList.copyOf(Transformations.zip(a, b, Pair.asBiFunction()));
    }

    public static <A, B, C> Iterable<C> zip(final Iterator<A> a, final Iterator<B> b, final BiFunction<A, B, C> zipper) {
        Preconditions.checkNotNull(a, (Object)"a is null");
        Preconditions.checkNotNull(b, (Object)"b is null");
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                return new UnmodifiableIterator<C>(){
                    int pos = 0;

                    public boolean hasNext() {
                        boolean bNext;
                        boolean aNext = a.hasNext();
                        if (aNext != (bNext = b.hasNext())) {
                            throw new IndexOutOfBoundsException("no element in " + (aNext ? "a" : "b") + " found at " + this.pos);
                        }
                        return aNext && bNext;
                    }

                    public C next() {
                        ++this.pos;
                        return zipper.apply(a.next(), b.next());
                    }
                };
            }
        };
    }

    public static <V> Function<V, V> noop() {
        return new NoTransformation();
    }

    public static <V> Function<V, Collection<? extends V>> asCollection() {
        return new ValueToCollection();
    }

    public static <S, D> Function<S, Collection<? extends D>> asCollection(Function<S, D> transformation) {
        return Functions.compose(new ValueToCollection(), transformation);
    }
}

