/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import de.flapdoodle.guava.functions.BiFunction;

public class Pair<A, B> {
    private final A a;
    private final B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A a() {
        return this.a;
    }

    public B b() {
        return this.b;
    }

    public String toString() {
        return "Pair[" + this.a + ", " + this.b + "]";
    }

    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
        result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
            return false;
        }
        return !(this.b == null ? other.b != null : !this.b.equals(other.b));
    }

    public static <AS, B, AD> Function<Pair<AS, B>, Pair<AD, B>> mapA(final Function<AS, AD> map) {
        return new Function<Pair<AS, B>, Pair<AD, B>>(){

            public Pair<AD, B> apply(Pair<AS, B> pair) {
                return Pair.of(map.apply(pair.a()), pair.b());
            }
        };
    }

    public static <A, BS, BD> Function<Pair<A, BS>, Pair<A, BD>> mapB(final Function<BS, BD> map) {
        return new Function<Pair<A, BS>, Pair<A, BD>>(){

            public Pair<A, BD> apply(Pair<A, BS> pair) {
                return Pair.of(pair.a(), map.apply(pair.b()));
            }
        };
    }

    public static <A, B> BiFunction<A, B, Pair<A, B>> asBiFunction() {
        return new BiFunction<A, B, Pair<A, B>>(){

            @Override
            public Pair<A, B> apply(A a, B b) {
                return Pair.of(a, b);
            }
        };
    }

    static class PairToValue<V>
    implements Function<Pair<?, V>, V> {
        PairToValue() {
        }

        public V apply(Pair<?, V> input) {
            return input.b();
        }
    }

    static class PairToKey<K>
    implements Function<Pair<K, ?>, K> {
        PairToKey() {
        }

        public K apply(Pair<K, ?> input) {
            return input.a();
        }
    }
}

