/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

public abstract class Varargs {
    private Varargs() {
    }

    public static <T> ImmutableList<T> asCollection(T arg, T ... others) {
        return ImmutableList.builder().add(arg).add((Object[])others).build();
    }

    public static <T> ImmutableList<T> asCollection(T arg, T other, T ... others) {
        return ImmutableList.builder().add(arg).add(other).add((Object[])others).build();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> asCollection(Collection<T> list, T arg, T ... others) {
        return ImmutableList.builder().addAll(list).add(arg).add((Object[])others).build();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> asCollection(T[] list, T arg, T ... others) {
        return ImmutableList.builder().add((Object[])list).add(arg).add((Object[])others).build();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> asCollectionPrependVarargs(Collection<T> list, T arg, T ... others) {
        return ImmutableList.builder().add(arg).add((Object[])others).addAll(list).build();
    }

    @SafeVarargs
    public static <T> ImmutableList<T> asCollectionPrependVarargs(T[] list, T arg, T ... others) {
        return ImmutableList.builder().add(arg).add((Object[])others).add((Object[])list).build();
    }

    public static <T> T[] asArray(Collection<? extends T> collection, Class<T> type) {
        return Iterables.toArray(collection, type);
    }
}

