/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;

public abstract class Sort {
    private Sort() {
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> source) {
        return Ordering.natural().sortedCopy(source);
    }

    public static <T> List<T> sortBy(Iterable<T> source, Comparator<? super T> comparator) {
        return Ordering.from(comparator).sortedCopy(source);
    }

    public static <T, S> List<T> sortBy(Iterable<T> source, Function<T, S> sortTransformation, Comparator<? super S> comparator) {
        return Sort.orderBy(sortTransformation, comparator).sortedCopy(source);
    }

    public static <T, S> Ordering<T> orderBy(Function<T, S> sortTransformation, Comparator<? super S> comparator) {
        return Ordering.from(comparator).onResultOf(sortTransformation);
    }

    public static <T, S extends Comparable<S>> List<T> sortBy(Iterable<T> source, Function<T, S> sortTransformation) {
        return Sort.sortBy(source, sortTransformation, Ordering.natural());
    }
}

