/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Equivalence;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.flapdoodle.guava.Foldleft;

public abstract class Merger {
    private Merger() {
    }

    public static <T> ImmutableList<T> merge(Iterable<? extends T> left, Iterable<? extends T> right, Equivalence<? super T> matcher, Foldleft<? super T, T> fold) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterable notMerged = right;
        for (T l : left) {
            Iterable matching = Iterables.filter(notMerged, (Predicate)matcher.equivalentTo(l));
            notMerged = Iterables.filter(notMerged, (Predicate)Predicates.not((Predicate)matcher.equivalentTo(l)));
            boolean noMatching = true;
            for (Object r : matching) {
                builder.add(fold.apply(l, r));
                noMatching = false;
            }
            if (!noMatching) continue;
            builder.add(l);
        }
        builder.addAll(notMerged);
        return builder.build();
    }
}

