/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.flapdoodle.guava.Foldleft;
import de.flapdoodle.guava.Types;
import java.util.Collection;
import java.util.EnumSet;

public abstract class Folds {
    private Folds() {
    }

    public static <S, D> D foldLeft(Iterable<? extends S> collection, Foldleft<? super S, D> foldFunction, D leftValue) {
        Preconditions.checkNotNull(collection, (Object)"collection is null");
        Preconditions.checkNotNull(foldFunction, (Object)"foldFunction is null");
        D ret = leftValue;
        for (S value : collection) {
            ret = foldFunction.apply(ret, value);
        }
        return ret;
    }

    public static <R, V> Foldleft<R, ImmutableList<? extends V>> asListFold(Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new ImmutableListFold(), valueTransformation);
    }

    public static <R, V> Foldleft<R, ImmutableSet<? extends V>> asSetFold(Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new ImmutableSetFold(), valueTransformation);
    }

    public static <R, V extends Enum<V>> Foldleft<R, EnumSet<V>> asEnumSetFold(Class<V> enumType, Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new EnumSetFold<V>(enumType), valueTransformation);
    }

    public static <R, V> Foldleft<R, Iterable<? extends V>> asIterableFold(Function<R, ? extends Iterable<? extends V>> valueTransformation) {
        return new IterableTransformationFold(new IterableFoldImpl(), valueTransformation);
    }

    static class ValueFromLeftIllegalFold<T, V>
    implements Foldleft<T, V> {
        private final Function<? super T, V> valueTransformation;

        public ValueFromLeftIllegalFold(Function<? super T, V> valueTransformation) {
            this.valueTransformation = valueTransformation;
        }

        @Override
        public V apply(V left, T right) {
            Object value = this.valueTransformation.apply(right);
            if (left != null) {
                throw new IllegalArgumentException("entry '" + right + "' mapped to '" + value + "' is allready mapped to the same key as '" + left + "'");
            }
            return (V)value;
        }
    }

    static class IterableTransformationFold<R, D, C extends Iterable<? extends D>>
    implements Foldleft<R, C> {
        private final Foldleft<Iterable<? extends D>, C> _fold;
        private final Function<R, ? extends Iterable<? extends D>> _transformation;

        public IterableTransformationFold(Foldleft<Iterable<? extends D>, C> fold, Function<R, ? extends Iterable<? extends D>> transformation) {
            this._fold = fold;
            this._transformation = transformation;
        }

        @Override
        public C apply(C left, R right) {
            return (C)((Iterable)this._fold.apply(left, (Iterable<D>)this._transformation.apply(right)));
        }
    }

    static class IterableFoldImpl<R>
    implements IterableFold<R, Iterable<? extends R>> {
        IterableFoldImpl() {
        }

        @Override
        public Iterable<? extends R> apply(Iterable<? extends R> left, Iterable<? extends R> right) {
            left = (Iterable)Types.defaultIfNull(left, ImmutableList.of());
            return Iterables.concat((Iterable)left, right);
        }
    }

    static interface IterableFold<R, C extends Iterable<? extends R>>
    extends Foldleft<Iterable<? extends R>, C> {
    }

    static class TransformationFold<R, D, C extends Collection<? extends D>>
    implements Foldleft<R, C> {
        private final Foldleft<Collection<? extends D>, C> _fold;
        private final Function<R, ? extends Collection<? extends D>> _transformation;

        public TransformationFold(Foldleft<Collection<? extends D>, C> fold, Function<R, ? extends Collection<? extends D>> transformation) {
            this._fold = fold;
            this._transformation = transformation;
        }

        @Override
        public C apply(C left, R right) {
            return (C)((Collection)this._fold.apply(left, (Collection<D>)this._transformation.apply(right)));
        }
    }

    static class EnumSetFold<R extends Enum<R>>
    implements CollectingFold<R, EnumSet<R>> {
        private final Class<R> _enumType;

        public EnumSetFold(Class<R> enumType) {
            this._enumType = enumType;
        }

        @Override
        public EnumSet<R> apply(EnumSet<R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, EnumSet.noneOf(this._enumType));
            if (right.isEmpty()) {
                return left;
            }
            EnumSet<R> ret = EnumSet.copyOf(left);
            ret.addAll(right);
            if (ret.size() < left.size() + right.size()) {
                throw new IllegalArgumentException("colliding entries: " + left + "-" + right);
            }
            return ret;
        }
    }

    static class ImmutableSetFold<R>
    implements CollectingFold<R, ImmutableSet<? extends R>> {
        ImmutableSetFold() {
        }

        @Override
        public ImmutableSet<? extends R> apply(ImmutableSet<? extends R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, ImmutableSet.of());
            if (right.isEmpty()) {
                return left;
            }
            ImmutableSet ret = left.isEmpty() ? ImmutableSet.copyOf(right) : ImmutableSet.builder().addAll((Iterable)left).addAll(right).build();
            if (ret.size() < left.size() + right.size()) {
                throw new IllegalArgumentException("colliding entries: " + left + "-" + right);
            }
            return ret;
        }
    }

    static class ImmutableListFold<R>
    implements CollectingFold<R, ImmutableList<? extends R>> {
        ImmutableListFold() {
        }

        @Override
        public ImmutableList<? extends R> apply(ImmutableList<? extends R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, ImmutableList.of());
            if (right.isEmpty()) {
                return left;
            }
            if (left.isEmpty()) {
                return ImmutableList.copyOf(right);
            }
            return ImmutableList.builder().addAll((Iterable)left).addAll(right).build();
        }
    }

    static interface CollectingFold<R, C extends Collection<? extends R>>
    extends Foldleft<Collection<? extends R>, C> {
    }
}

