/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Preconditions;
import de.flapdoodle.guava.Logics;
import java.io.Serializable;

public abstract class Either<L, R>
implements Serializable {
    public abstract boolean isLeft();

    public abstract L left();

    public abstract R right();

    public static <L, R> Left<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Right<L, R> right(R value) {
        return new Right(value);
    }

    public static <L, R> Either<L, R> leftOrRight(L left, R right, String errorMessage) {
        Preconditions.checkArgument((boolean)Logics.xor(left, right), (Object)errorMessage);
        if (left != null) {
            return Either.left(left);
        }
        return Either.right(right);
    }

    public static <L, R> Either<L, R> leftOrRight(L left, R right) {
        return Either.leftOrRight(left, right, "only left or right");
    }

    public static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public L left() {
            throw new NullPointerException("is right");
        }

        @Override
        public R right() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Right other = (Right)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public L left() {
            return this.value;
        }

        @Override
        public R right() {
            throw new NullPointerException("is left");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Left other = (Left)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

