/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import de.flapdoodle.guava.Foldleft;
import de.flapdoodle.guava.Folds;
import de.flapdoodle.guava.Transformations;
import de.flapdoodle.guava.functions.NoTransformation;
import java.util.Map;

public abstract class MapTransformations {
    private MapTransformations() {
    }

    public static <S, D, V, M> Map<D, M> transform(Map<S, V> map, final Function<? super S, D> keytransformation, final Foldleft<? super V, M> valuetransformation) {
        return Transformations.map(map.entrySet(), new Function<Map.Entry<S, V>, D>(){

            public D apply(Map.Entry<S, V> input) {
                return keytransformation.apply(input.getKey());
            }
        }, new Foldleft<Map.Entry<S, V>, M>(){

            @Override
            public M apply(M left, Map.Entry<S, V> right) {
                try {
                    return valuetransformation.apply(left, right.getValue());
                }
                catch (RuntimeException rx) {
                    throw new RuntimeException("apply left(" + left + ") and right(" + right + ")", rx);
                }
            }
        });
    }

    public static <S, D, V, M> Map<D, M> transform(Map<S, V> map, Function<? super S, D> keytransformation, Function<? super V, M> valuetransformation) {
        return MapTransformations.transform(map, keytransformation, new Folds.ValueFromLeftIllegalFold<V, M>(valuetransformation));
    }

    public static <S, D, V> Map<D, V> transformKeys(Map<S, V> map, Function<? super S, D> keytransformation) {
        return MapTransformations.transform(map, keytransformation, new NoTransformation());
    }
}

