/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.collect.Maps;
import de.flapdoodle.guava.MapCreator;
import java.util.EnumMap;
import java.util.Map;

public abstract class MapCreators {
    private MapCreators() {
    }

    public static <K extends Enum<K>, V> MapCreator<K, V, EnumMap<K, V>> enumMap(Class<K> type) {
        return new EnumMapCreator(type);
    }

    public static <K, V> MapCreator<K, V, Map<K, V>> linkedHashMap() {
        return new LinkedHashMapCreator();
    }

    private static final class LinkedHashMapCreator<K, V>
    implements MapCreator<K, V, Map<K, V>> {
        private LinkedHashMapCreator() {
        }

        @Override
        public final Map<K, V> newInstance() {
            return Maps.newLinkedHashMap();
        }
    }

    private static final class EnumMapCreator<K extends Enum<K>, V>
    implements MapCreator<K, V, EnumMap<K, V>> {
        private final Class<K> type;

        EnumMapCreator(Class<K> type) {
            this.type = type;
        }

        @Override
        public final EnumMap<K, V> newInstance() {
            return Maps.newEnumMap(this.type);
        }
    }
}

