/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.flapdoodle.guava.Foldleft;
import de.flapdoodle.guava.Types;
import java.util.Collection;
import java.util.EnumSet;

public abstract class Folds {
    private Folds() {
    }

    public static <S, D> D foldLeft(Collection<? extends S> collection, Foldleft<? super S, D> foldFunction, D leftValue) {
        Preconditions.checkNotNull(collection, (Object)"collection is null");
        Preconditions.checkNotNull(foldFunction, (Object)"foldFunction is null");
        D ret = leftValue;
        for (S value : collection) {
            ret = foldFunction.apply(ret, value);
        }
        return ret;
    }

    public static <R, V> Foldleft<R, ImmutableList<V>> asListFold(Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new ImmutableListFold(), valueTransformation);
    }

    public static <R, V> Foldleft<R, ImmutableSet<V>> asSetFold(Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new ImmutableSetFold(), valueTransformation);
    }

    public static <R, V extends Enum<V>> Foldleft<R, EnumSet<V>> asEnumSetFold(Class<V> enumType, Function<R, ? extends Collection<? extends V>> valueTransformation) {
        return new TransformationFold(new EnumSetFold<V>(enumType), valueTransformation);
    }

    static class ValueFromLeftIllegalFold<T, V>
    implements Foldleft<T, V> {
        private final Function<? super T, V> valueTransformation;

        public ValueFromLeftIllegalFold(Function<? super T, V> valueTransformation) {
            this.valueTransformation = valueTransformation;
        }

        @Override
        public V apply(V left, T right) {
            Object value = this.valueTransformation.apply(right);
            if (left != null) {
                throw new IllegalArgumentException("Entry " + right + " with mapped to " + value + " is allready mapped to the same key as " + left);
            }
            return (V)value;
        }
    }

    static class TransformationFold<R, D, C extends Collection<D>>
    implements Foldleft<R, C> {
        private final CollectingFold<D, C> _fold;
        private final Function<R, ? extends Collection<? extends D>> _transformation;

        public TransformationFold(CollectingFold<D, C> fold, Function<R, ? extends Collection<? extends D>> transformation) {
            this._fold = fold;
            this._transformation = transformation;
        }

        @Override
        public C apply(C left, R right) {
            return (C)((Collection)this._fold.apply(left, this._transformation.apply(right)));
        }
    }

    static class EnumSetFold<R extends Enum<R>>
    implements CollectingFold<R, EnumSet<R>> {
        private final Class<R> _enumType;

        public EnumSetFold(Class<R> enumType) {
            this._enumType = enumType;
        }

        @Override
        public EnumSet<R> apply(EnumSet<R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, EnumSet.noneOf(this._enumType));
            if (right.isEmpty()) {
                return left;
            }
            EnumSet<R> ret = EnumSet.copyOf(left);
            ret.addAll(right);
            if (ret.size() < left.size() + right.size()) {
                throw new IllegalArgumentException("colliding entries: " + left + "-" + right);
            }
            return ret;
        }
    }

    static class ImmutableSetFold<R>
    implements CollectingFold<R, ImmutableSet<R>> {
        ImmutableSetFold() {
        }

        @Override
        public ImmutableSet<R> apply(ImmutableSet<R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, ImmutableSet.of());
            if (right.isEmpty()) {
                return left;
            }
            ImmutableSet ret = left.isEmpty() ? ImmutableSet.copyOf(right) : ImmutableSet.builder().addAll((Iterable)left).addAll(right).build();
            if (ret.size() < left.size() + right.size()) {
                throw new IllegalArgumentException("colliding entries: " + left + "-" + right);
            }
            return ret;
        }
    }

    static class ImmutableListFold<R>
    implements CollectingFold<R, ImmutableList<R>> {
        ImmutableListFold() {
        }

        @Override
        public ImmutableList<R> apply(ImmutableList<R> left, Collection<? extends R> right) {
            left = Types.defaultIfNull(left, ImmutableList.of());
            if (right.isEmpty()) {
                return left;
            }
            if (left.isEmpty()) {
                return ImmutableList.copyOf(right);
            }
            return ImmutableList.builder().addAll((Iterable)left).addAll(right).build();
        }
    }

    static interface CollectingFold<R, C extends Collection<R>>
    extends Foldleft<Collection<? extends R>, C> {
    }
}

