/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.guava;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;

public abstract class Expectations {
    private Expectations() {
    }

    private static <T> Optional<T> intNoneOrOne(Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator, (Object)"iterator is null");
        if (!iterator.hasNext()) {
            return Optional.absent();
        }
        return Optional.of(iterator.next());
    }

    public static <T> Optional<T> noneOrOneIfOnlyOne(Iterator<T> iterator) {
        Optional<T> ret = Expectations.intNoneOrOne(iterator);
        if (iterator.hasNext()) {
            return Optional.absent();
        }
        return ret;
    }

    public static <T> T oneIfOnlyOne(Iterator<T> iterator, T defaultValue) {
        return (T)Expectations.noneOrOneIfOnlyOne(iterator).or(Optional.fromNullable(defaultValue)).orNull();
    }

    public static <T> Optional<T> noneOrOneIfOnlyOne(Iterable<T> values) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        return Expectations.noneOrOneIfOnlyOne(values.iterator());
    }

    public static <T> T oneIfOnlyOne(Iterable<T> values, T defaultValue) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        return Expectations.oneIfOnlyOne(values.iterator(), defaultValue);
    }

    public static <T> Optional<T> noneOrOne(Iterator<T> iterator) {
        Optional<T> ret = Expectations.intNoneOrOne(iterator);
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (Object)"contains more than one");
        return ret;
    }

    public static <T> Optional<T> noneOrOne(Iterable<T> values) {
        Preconditions.checkNotNull(values, (Object)"values is null");
        return Expectations.noneOrOne(values.iterator());
    }

    public static <T> boolean any(Collection<T> candidates, Predicate<T> condition) {
        return !Collections2.filter(candidates, condition).isEmpty();
    }
}

