package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VerticesAndEdges}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVerticesAndEdges.builder()}.
 */
@Generated(from = "VerticesAndEdges", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableVerticesAndEdges<V, E> implements VerticesAndEdges<V, E> {
  private final Set<V> vertices;
  private final Set<Edge<V, E>> edges;
  private final Set<Loop<V, E>> loops;

  private ImmutableVerticesAndEdges(ImmutableVerticesAndEdges.Builder<V, E> builder) {
    this.vertices = createUnmodifiableSet(builder.vertices);
    if (builder.edgesIsSet()) {
      initShim.edges(createUnmodifiableSet(builder.edges));
    }
    if (builder.loopsIsSet()) {
      initShim.loops(createUnmodifiableSet(builder.loops));
    }
    this.edges = initShim.edges();
    this.loops = initShim.loops();
    this.initShim = null;
  }

  private ImmutableVerticesAndEdges(
      Set<V> vertices,
      Set<Edge<V, E>> edges,
      Set<Loop<V, E>> loops) {
    this.vertices = vertices;
    this.edges = edges;
    this.loops = loops;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VerticesAndEdges", generator = "Immutables")
  private final class InitShim {
    private byte edgesBuildStage = STAGE_UNINITIALIZED;
    private Set<Edge<V, E>> edges;

    Set<Edge<V, E>> edges() {
      if (edgesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (edgesBuildStage == STAGE_UNINITIALIZED) {
        edgesBuildStage = STAGE_INITIALIZING;
        this.edges = createUnmodifiableSet(createSafeList(edgesInitialize(), true, false));
        edgesBuildStage = STAGE_INITIALIZED;
      }
      return this.edges;
    }

    void edges(Set<Edge<V, E>> edges) {
      this.edges = edges;
      edgesBuildStage = STAGE_INITIALIZED;
    }

    private byte loopsBuildStage = STAGE_UNINITIALIZED;
    private Set<Loop<V, E>> loops;

    Set<Loop<V, E>> loops() {
      if (loopsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (loopsBuildStage == STAGE_UNINITIALIZED) {
        loopsBuildStage = STAGE_INITIALIZING;
        this.loops = createUnmodifiableSet(createSafeList(loopsInitialize(), true, false));
        loopsBuildStage = STAGE_INITIALIZED;
      }
      return this.loops;
    }

    void loops(Set<Loop<V, E>> loops) {
      this.loops = loops;
      loopsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (edgesBuildStage == STAGE_INITIALIZING) attributes.add("edges");
      if (loopsBuildStage == STAGE_INITIALIZING) attributes.add("loops");
      return "Cannot build VerticesAndEdges, attribute initializers form cycle " + attributes;
    }
  }

  private Set<Edge<V, E>> edgesInitialize() {
    return VerticesAndEdges.super.edges();
  }

  private Set<Loop<V, E>> loopsInitialize() {
    return VerticesAndEdges.super.loops();
  }

  /**
   * @return The value of the {@code vertices} attribute
   */
  @Override
  public Set<V> vertices() {
    return vertices;
  }

  /**
   * @return The value of the {@code edges} attribute
   */
  @Override
  public Set<Edge<V, E>> edges() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.edges()
        : this.edges;
  }

  /**
   * @return The value of the {@code loops} attribute
   */
  @Override
  public Set<Loop<V, E>> loops() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.loops()
        : this.loops;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#vertices() vertices}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableVerticesAndEdges<V, E> withVertices(V... elements) {
    Set<V> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableVerticesAndEdges<>(newValue, this.edges, this.loops));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#vertices() vertices}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of vertices elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVerticesAndEdges<V, E> withVertices(Iterable<? extends V> elements) {
    if (this.vertices == elements) return this;
    Set<V> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return validate(new ImmutableVerticesAndEdges<>(newValue, this.edges, this.loops));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#edges() edges}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableVerticesAndEdges<V, E> withEdges(Edge<V, E>... elements) {
    Set<Edge<V, E>> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableVerticesAndEdges<>(this.vertices, newValue, this.loops));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#edges() edges}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of edges elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVerticesAndEdges<V, E> withEdges(Iterable<? extends Edge<V, E>> elements) {
    if (this.edges == elements) return this;
    Set<Edge<V, E>> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return validate(new ImmutableVerticesAndEdges<>(this.vertices, newValue, this.loops));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#loops() loops}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableVerticesAndEdges<V, E> withLoops(Loop<V, E>... elements) {
    Set<Loop<V, E>> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableVerticesAndEdges<>(this.vertices, this.edges, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VerticesAndEdges#loops() loops}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of loops elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVerticesAndEdges<V, E> withLoops(Iterable<? extends Loop<V, E>> elements) {
    if (this.loops == elements) return this;
    Set<Loop<V, E>> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return validate(new ImmutableVerticesAndEdges<>(this.vertices, this.edges, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVerticesAndEdges} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVerticesAndEdges<?, ?>
        && equalTo((ImmutableVerticesAndEdges<?, ?>) another);
  }

  private boolean equalTo(ImmutableVerticesAndEdges<?, ?> another) {
    return vertices.equals(another.vertices)
        && edges.equals(another.edges)
        && loops.equals(another.loops);
  }

  /**
   * Computes a hash code from attributes: {@code vertices}, {@code edges}, {@code loops}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + vertices.hashCode();
    h += (h << 5) + edges.hashCode();
    h += (h << 5) + loops.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VerticesAndEdges} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VerticesAndEdges{"
        + "vertices=" + vertices
        + ", edges=" + edges
        + ", loops=" + loops
        + "}";
  }

  private static <V, E> ImmutableVerticesAndEdges<V, E> validate(ImmutableVerticesAndEdges<V, E> instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link VerticesAndEdges} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @param instance The instance to copy
   * @return A copied immutable VerticesAndEdges instance
   */
  public static <V, E> ImmutableVerticesAndEdges<V, E> copyOf(VerticesAndEdges<V, E> instance) {
    if (instance instanceof ImmutableVerticesAndEdges<?, ?>) {
      return (ImmutableVerticesAndEdges<V, E>) instance;
    }
    return ImmutableVerticesAndEdges.<V, E>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVerticesAndEdges ImmutableVerticesAndEdges}.
   * <pre>
   * ImmutableVerticesAndEdges.&amp;lt;V, E&amp;gt;builder()
   *    .addVertices|addAllVertices(V) // {@link VerticesAndEdges#vertices() vertices} elements
   *    .addEdges|addAllEdges(de.flapdoodle.graph.Edge&amp;lt;V, E&amp;gt;) // {@link VerticesAndEdges#edges() edges} elements
   *    .addLoops|addAllLoops(de.flapdoodle.graph.Loop&amp;lt;V, E&amp;gt;) // {@link VerticesAndEdges#loops() loops} elements
   *    .build();
   * </pre>
   * @param <V> generic parameter V
   * @param <E> generic parameter E
   * @return A new ImmutableVerticesAndEdges builder
   */
  public static <V, E> ImmutableVerticesAndEdges.Builder<V, E> builder() {
    return new ImmutableVerticesAndEdges.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableVerticesAndEdges ImmutableVerticesAndEdges}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VerticesAndEdges", generator = "Immutables")
  public static final class Builder<V, E> {
    private static final long OPT_BIT_EDGES = 0x1L;
    private static final long OPT_BIT_LOOPS = 0x2L;
    private long optBits;

    private List<V> vertices = new ArrayList<V>();
    private List<Edge<V, E>> edges = new ArrayList<Edge<V, E>>();
    private List<Loop<V, E>> loops = new ArrayList<Loop<V, E>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VerticesAndEdges} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> from(VerticesAndEdges<V, E> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllVertices(instance.vertices());
      addAllEdges(instance.edges());
      addAllLoops(instance.loops());
      return this;
    }

    /**
     * Adds one element to {@link VerticesAndEdges#vertices() vertices} set.
     * @param element A vertices element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addVertices(V element) {
      this.vertices.add(Objects.requireNonNull(element, "vertices element"));
      return this;
    }

    /**
     * Adds elements to {@link VerticesAndEdges#vertices() vertices} set.
     * @param elements An array of vertices elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<V, E> addVertices(V... elements) {
      for (V element : elements) {
        this.vertices.add(Objects.requireNonNull(element, "vertices element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VerticesAndEdges#vertices() vertices} set.
     * @param elements An iterable of vertices elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> vertices(Iterable<? extends V> elements) {
      this.vertices.clear();
      return addAllVertices(elements);
    }

    /**
     * Adds elements to {@link VerticesAndEdges#vertices() vertices} set.
     * @param elements An iterable of vertices elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addAllVertices(Iterable<? extends V> elements) {
      for (V element : elements) {
        this.vertices.add(Objects.requireNonNull(element, "vertices element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link VerticesAndEdges#edges() edges} set.
     * @param element A edges element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addEdges(Edge<V, E> element) {
      this.edges.add(Objects.requireNonNull(element, "edges element"));
      optBits |= OPT_BIT_EDGES;
      return this;
    }

    /**
     * Adds elements to {@link VerticesAndEdges#edges() edges} set.
     * @param elements An array of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<V, E> addEdges(Edge<V, E>... elements) {
      for (Edge<V, E> element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      optBits |= OPT_BIT_EDGES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VerticesAndEdges#edges() edges} set.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> edges(Iterable<? extends Edge<V, E>> elements) {
      this.edges.clear();
      return addAllEdges(elements);
    }

    /**
     * Adds elements to {@link VerticesAndEdges#edges() edges} set.
     * @param elements An iterable of edges elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addAllEdges(Iterable<? extends Edge<V, E>> elements) {
      for (Edge<V, E> element : elements) {
        this.edges.add(Objects.requireNonNull(element, "edges element"));
      }
      optBits |= OPT_BIT_EDGES;
      return this;
    }

    /**
     * Adds one element to {@link VerticesAndEdges#loops() loops} set.
     * @param element A loops element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addLoops(Loop<V, E> element) {
      this.loops.add(Objects.requireNonNull(element, "loops element"));
      optBits |= OPT_BIT_LOOPS;
      return this;
    }

    /**
     * Adds elements to {@link VerticesAndEdges#loops() loops} set.
     * @param elements An array of loops elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<V, E> addLoops(Loop<V, E>... elements) {
      for (Loop<V, E> element : elements) {
        this.loops.add(Objects.requireNonNull(element, "loops element"));
      }
      optBits |= OPT_BIT_LOOPS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link VerticesAndEdges#loops() loops} set.
     * @param elements An iterable of loops elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> loops(Iterable<? extends Loop<V, E>> elements) {
      this.loops.clear();
      return addAllLoops(elements);
    }

    /**
     * Adds elements to {@link VerticesAndEdges#loops() loops} set.
     * @param elements An iterable of loops elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<V, E> addAllLoops(Iterable<? extends Loop<V, E>> elements) {
      for (Loop<V, E> element : elements) {
        this.loops.add(Objects.requireNonNull(element, "loops element"));
      }
      optBits |= OPT_BIT_LOOPS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVerticesAndEdges ImmutableVerticesAndEdges}.
     * @return An immutable instance of VerticesAndEdges
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVerticesAndEdges<V, E> build() {
      return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(this));
    }

    private boolean edgesIsSet() {
      return (optBits & OPT_BIT_EDGES) != 0;
    }

    private boolean loopsIsSet() {
      return (optBits & OPT_BIT_LOOPS) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
