package de.flapdoodle.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GraphAsDot}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGraphAsDot.builder()}.
 */
@Generated(from = "GraphAsDot", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableGraphAsDot<T> implements GraphAsDot<T> {
  private final Function<T, String> nodeAsString;
  private final BiFunction<T, T, Map<String, String>> edgeAttributes;
  private final Function<T, Map<String, String>> nodeAttributes;
  private final String label;

  private ImmutableGraphAsDot(ImmutableGraphAsDot.Builder<T> builder) {
    this.nodeAsString = builder.nodeAsString;
    if (builder.edgeAttributes != null) {
      initShim.edgeAttributes(builder.edgeAttributes);
    }
    if (builder.nodeAttributes != null) {
      initShim.nodeAttributes(builder.nodeAttributes);
    }
    if (builder.label != null) {
      initShim.label(builder.label);
    }
    this.edgeAttributes = initShim.edgeAttributes();
    this.nodeAttributes = initShim.nodeAttributes();
    this.label = initShim.label();
    this.initShim = null;
  }

  private ImmutableGraphAsDot(
      Function<T, String> nodeAsString,
      BiFunction<T, T, Map<String, String>> edgeAttributes,
      Function<T, Map<String, String>> nodeAttributes,
      String label) {
    this.nodeAsString = nodeAsString;
    this.edgeAttributes = edgeAttributes;
    this.nodeAttributes = nodeAttributes;
    this.label = label;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "GraphAsDot", generator = "Immutables")
  private final class InitShim {
    private byte edgeAttributesBuildStage = STAGE_UNINITIALIZED;
    private BiFunction<T, T, Map<String, String>> edgeAttributes;

    BiFunction<T, T, Map<String, String>> edgeAttributes() {
      if (edgeAttributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (edgeAttributesBuildStage == STAGE_UNINITIALIZED) {
        edgeAttributesBuildStage = STAGE_INITIALIZING;
        this.edgeAttributes = Objects.requireNonNull(edgeAttributesInitialize(), "edgeAttributes");
        edgeAttributesBuildStage = STAGE_INITIALIZED;
      }
      return this.edgeAttributes;
    }

    void edgeAttributes(BiFunction<T, T, Map<String, String>> edgeAttributes) {
      this.edgeAttributes = edgeAttributes;
      edgeAttributesBuildStage = STAGE_INITIALIZED;
    }

    private byte nodeAttributesBuildStage = STAGE_UNINITIALIZED;
    private Function<T, Map<String, String>> nodeAttributes;

    Function<T, Map<String, String>> nodeAttributes() {
      if (nodeAttributesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nodeAttributesBuildStage == STAGE_UNINITIALIZED) {
        nodeAttributesBuildStage = STAGE_INITIALIZING;
        this.nodeAttributes = Objects.requireNonNull(nodeAttributesInitialize(), "nodeAttributes");
        nodeAttributesBuildStage = STAGE_INITIALIZED;
      }
      return this.nodeAttributes;
    }

    void nodeAttributes(Function<T, Map<String, String>> nodeAttributes) {
      this.nodeAttributes = nodeAttributes;
      nodeAttributesBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String label() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = Objects.requireNonNull(labelInitialize(), "label");
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void label(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (edgeAttributesBuildStage == STAGE_INITIALIZING) attributes.add("edgeAttributes");
      if (nodeAttributesBuildStage == STAGE_INITIALIZING) attributes.add("nodeAttributes");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      return "Cannot build GraphAsDot, attribute initializers form cycle " + attributes;
    }
  }

  private BiFunction<T, T, Map<String, String>> edgeAttributesInitialize() {
    return GraphAsDot.super.edgeAttributes();
  }

  private Function<T, Map<String, String>> nodeAttributesInitialize() {
    return GraphAsDot.super.nodeAttributes();
  }

  private String labelInitialize() {
    return GraphAsDot.super.label();
  }

  /**
   * @return The value of the {@code nodeAsString} attribute
   */
  @Override
  public Function<T, String> nodeAsString() {
    return nodeAsString;
  }

  /**
   * @return The value of the {@code edgeAttributes} attribute
   */
  @Override
  public BiFunction<T, T, Map<String, String>> edgeAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.edgeAttributes()
        : this.edgeAttributes;
  }

  /**
   * @return The value of the {@code nodeAttributes} attribute
   */
  @Override
  public Function<T, Map<String, String>> nodeAttributes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nodeAttributes()
        : this.nodeAttributes;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public String label() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.label()
        : this.label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#nodeAsString() nodeAsString} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAsString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withNodeAsString(Function<T, String> value) {
    if (this.nodeAsString == value) return this;
    Function<T, String> newValue = Objects.requireNonNull(value, "nodeAsString");
    return new ImmutableGraphAsDot<>(newValue, this.edgeAttributes, this.nodeAttributes, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#edgeAttributes() edgeAttributes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for edgeAttributes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withEdgeAttributes(BiFunction<T, T, Map<String, String>> value) {
    if (this.edgeAttributes == value) return this;
    BiFunction<T, T, Map<String, String>> newValue = Objects.requireNonNull(value, "edgeAttributes");
    return new ImmutableGraphAsDot<>(this.nodeAsString, newValue, this.nodeAttributes, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#nodeAttributes() nodeAttributes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeAttributes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withNodeAttributes(Function<T, Map<String, String>> value) {
    if (this.nodeAttributes == value) return this;
    Function<T, Map<String, String>> newValue = Objects.requireNonNull(value, "nodeAttributes");
    return new ImmutableGraphAsDot<>(this.nodeAsString, this.edgeAttributes, newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GraphAsDot#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGraphAsDot<T> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableGraphAsDot<>(this.nodeAsString, this.edgeAttributes, this.nodeAttributes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGraphAsDot} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGraphAsDot<?>
        && equalTo((ImmutableGraphAsDot<?>) another);
  }

  private boolean equalTo(ImmutableGraphAsDot<?> another) {
    return nodeAsString.equals(another.nodeAsString)
        && edgeAttributes.equals(another.edgeAttributes)
        && nodeAttributes.equals(another.nodeAttributes)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code nodeAsString}, {@code edgeAttributes}, {@code nodeAttributes}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + nodeAsString.hashCode();
    h += (h << 5) + edgeAttributes.hashCode();
    h += (h << 5) + nodeAttributes.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GraphAsDot} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GraphAsDot{"
        + "nodeAsString=" + nodeAsString
        + ", edgeAttributes=" + edgeAttributes
        + ", nodeAttributes=" + nodeAttributes
        + ", label=" + label
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link GraphAsDot} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GraphAsDot instance
   */
  public static <T> ImmutableGraphAsDot<T> copyOf(GraphAsDot<T> instance) {
    if (instance instanceof ImmutableGraphAsDot<?>) {
      return (ImmutableGraphAsDot<T>) instance;
    }
    return ImmutableGraphAsDot.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
   * <pre>
   * ImmutableGraphAsDot.&amp;lt;T&amp;gt;builder()
   *    .nodeAsString(function.Function&amp;lt;T, String&amp;gt;) // required {@link GraphAsDot#nodeAsString() nodeAsString}
   *    .edgeAttributes(function.BiFunction&amp;lt;T, T, Map&amp;lt;String, String&amp;gt;&amp;gt;) // optional {@link GraphAsDot#edgeAttributes() edgeAttributes}
   *    .nodeAttributes(function.Function&amp;lt;T, Map&amp;lt;String, String&amp;gt;&amp;gt;) // optional {@link GraphAsDot#nodeAttributes() nodeAttributes}
   *    .label(String) // optional {@link GraphAsDot#label() label}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param nodeAsString {@code nodeAsString} parameter
   * @return A new ImmutableGraphAsDot builder
   */
  public static <T> ImmutableGraphAsDot.Builder<T> builder(Function<T, String> nodeAsString) {
    return new ImmutableGraphAsDot.Builder<>(nodeAsString);
  }

  static <T> ImmutableGraphAsDot.Builder<T> builder() {
    return new ImmutableGraphAsDot.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GraphAsDot", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_NODE_AS_STRING = 0x1L;
    private long initBits = 0x1L;

    private Function<T, String> nodeAsString;
    private BiFunction<T, T, Map<String, String>> edgeAttributes;
    private Function<T, Map<String, String>> nodeAttributes;
    private String label;

    private Builder(Function<T, String> nodeAsString) {
      nodeAsString(nodeAsString);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GraphAsDot} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(GraphAsDot<T> instance) {
      Objects.requireNonNull(instance, "instance");
      nodeAsString(instance.nodeAsString());
      edgeAttributes(instance.edgeAttributes());
      nodeAttributes(instance.nodeAttributes());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#nodeAsString() nodeAsString} attribute.
     * @param nodeAsString The value for nodeAsString 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<T> nodeAsString(Function<T, String> nodeAsString) {
      this.nodeAsString = Objects.requireNonNull(nodeAsString, "nodeAsString");
      initBits &= ~INIT_BIT_NODE_AS_STRING;
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#edgeAttributes() edgeAttributes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#edgeAttributes() edgeAttributes}.</em>
     * @param edgeAttributes The value for edgeAttributes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> edgeAttributes(BiFunction<T, T, Map<String, String>> edgeAttributes) {
      this.edgeAttributes = Objects.requireNonNull(edgeAttributes, "edgeAttributes");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#nodeAttributes() nodeAttributes} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#nodeAttributes() nodeAttributes}.</em>
     * @param nodeAttributes The value for nodeAttributes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> nodeAttributes(Function<T, Map<String, String>> nodeAttributes) {
      this.nodeAttributes = Objects.requireNonNull(nodeAttributes, "nodeAttributes");
      return this;
    }

    /**
     * Initializes the value for the {@link GraphAsDot#label() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link GraphAsDot#label() label}.</em>
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGraphAsDot ImmutableGraphAsDot}.
     * @return An immutable instance of GraphAsDot
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGraphAsDot<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGraphAsDot<T>(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE_AS_STRING) != 0) attributes.add("nodeAsString");
      return "Cannot build GraphAsDot, some of required attributes are not set " + attributes;
    }
  }
}
