package de.flapdoodle.eval.example;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.StringValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStringValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStringValue.of()}.
 */
@Generated(from = "Value.StringValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableStringValue extends Value.StringValue {
  private final String wrapped;

  private ImmutableStringValue(String wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableStringValue(ImmutableStringValue original, String wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public String wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.StringValue#wrapped() wrapped} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStringValue withWrapped(String value) {
    String newValue = Objects.requireNonNull(value, "wrapped");
    if (this.wrapped.equals(newValue)) return this;
    return new ImmutableStringValue(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStringValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStringValue
        && equalTo(0, (ImmutableStringValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableStringValue another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code StringValue} instance.
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable StringValue instance
   */
  public static ImmutableStringValue of(String wrapped) {
    return new ImmutableStringValue(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Value.StringValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StringValue instance
   */
  public static ImmutableStringValue copyOf(Value.StringValue instance) {
    if (instance instanceof ImmutableStringValue) {
      return (ImmutableStringValue) instance;
    }
    return ImmutableStringValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStringValue ImmutableStringValue}.
   * <pre>
   * ImmutableStringValue.builder()
   *    .wrapped(String) // required {@link Value.StringValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableStringValue builder
   */
  public static ImmutableStringValue.Builder builder() {
    return new ImmutableStringValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStringValue ImmutableStringValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.StringValue", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private String wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StringValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.StringValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.StringValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(String wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStringValue ImmutableStringValue}.
     * @return An immutable instance of StringValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStringValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStringValue(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build StringValue, some of required attributes are not set " + attributes;
    }
  }
}
