package de.flapdoodle.eval.example;

import de.flapdoodle.eval.core.Nullable;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.NullValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullValue.builder()}.
 */
@Generated(from = "Value.NullValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableNullValue extends Value.NullValue {
  private final @Nullable Void wrapped;

  private ImmutableNullValue(@Nullable Void wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public @Nullable Void wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.NullValue#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullValue withWrapped(@Nullable Void value) {
    if (this.wrapped == value) return this;
    return new ImmutableNullValue(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullValue
        && equalTo(0, (ImmutableNullValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullValue another) {
    return Objects.equals(wrapped, another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(wrapped);
    return h;
  }

  /**
   * Creates an immutable copy of a {@link Value.NullValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullValue instance
   */
  public static ImmutableNullValue copyOf(Value.NullValue instance) {
    if (instance instanceof ImmutableNullValue) {
      return (ImmutableNullValue) instance;
    }
    return ImmutableNullValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullValue ImmutableNullValue}.
   * <pre>
   * ImmutableNullValue.builder()
   *    .wrapped(Void | null) // nullable {@link Value.NullValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableNullValue builder
   */
  public static ImmutableNullValue.Builder builder() {
    return new ImmutableNullValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullValue ImmutableNullValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.NullValue", generator = "Immutables")
  public static final class Builder {
    private Void wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.NullValue instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Void wrappedValue = instance.wrapped();
      if (wrappedValue != null) {
        wrapped(wrappedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Value.NullValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(@Nullable Void wrapped) {
      this.wrapped = wrapped;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullValue ImmutableNullValue}.
     * @return An immutable instance of NullValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullValue build() {
      return new ImmutableNullValue(wrapped);
    }
  }
}
