package de.flapdoodle.eval.example;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.DateTimeValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDateTimeValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDateTimeValue.of()}.
 */
@Generated(from = "Value.DateTimeValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDateTimeValue extends Value.DateTimeValue {
  private final Instant wrapped;

  private ImmutableDateTimeValue(Instant wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableDateTimeValue(ImmutableDateTimeValue original, Instant wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public Instant wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.DateTimeValue#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDateTimeValue withWrapped(Instant value) {
    if (this.wrapped == value) return this;
    Instant newValue = Objects.requireNonNull(value, "wrapped");
    return new ImmutableDateTimeValue(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDateTimeValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDateTimeValue
        && equalTo(0, (ImmutableDateTimeValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDateTimeValue another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DateTimeValue} instance.
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable DateTimeValue instance
   */
  public static ImmutableDateTimeValue of(Instant wrapped) {
    return new ImmutableDateTimeValue(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Value.DateTimeValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DateTimeValue instance
   */
  public static ImmutableDateTimeValue copyOf(Value.DateTimeValue instance) {
    if (instance instanceof ImmutableDateTimeValue) {
      return (ImmutableDateTimeValue) instance;
    }
    return ImmutableDateTimeValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDateTimeValue ImmutableDateTimeValue}.
   * <pre>
   * ImmutableDateTimeValue.builder()
   *    .wrapped(java.time.Instant) // required {@link Value.DateTimeValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableDateTimeValue builder
   */
  public static ImmutableDateTimeValue.Builder builder() {
    return new ImmutableDateTimeValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDateTimeValue ImmutableDateTimeValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.DateTimeValue", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private Instant wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DateTimeValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.DateTimeValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.DateTimeValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(Instant wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDateTimeValue ImmutableDateTimeValue}.
     * @return An immutable instance of DateTimeValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDateTimeValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDateTimeValue(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build DateTimeValue, some of required attributes are not set " + attributes;
    }
  }
}
