package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueNode.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueNode.of()}.
 */
@Generated(from = "ValueNode", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableValueNode<T> extends ValueNode<T> {
  private final Token token;
  private final Evaluated<T> value;

  private ImmutableValueNode(Token token, Evaluated<T> value) {
    this.token = Objects.requireNonNull(token, "token");
    this.value = Objects.requireNonNull(value, "value");
  }

  private ImmutableValueNode(
      ImmutableValueNode<T> original,
      Token token,
      Evaluated<T> value) {
    this.token = token;
    this.value = value;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Token token() {
    return token;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  protected Evaluated<T> value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueNode#token() token} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueNode<T> withToken(Token value) {
    if (this.token == value) return this;
    Token newValue = Objects.requireNonNull(value, "token");
    return new ImmutableValueNode<>(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueNode#value() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueNode<T> withValue(Evaluated<T> value) {
    if (this.value == value) return this;
    Evaluated<T> newValue = Objects.requireNonNull(value, "value");
    return new ImmutableValueNode<>(this, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueNode<?>
        && equalTo(0, (ImmutableValueNode<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueNode<?> another) {
    return token.equals(another.token)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + token.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ValueNode{"
        + "token=" + token
        + ", value=" + value
        + "}";
  }

  /**
   * Construct a new immutable {@code ValueNode} instance.
 * @param <T> generic parameter T
   * @param token The value for the {@code token} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable ValueNode instance
   */
  public static <T> ImmutableValueNode<T> of(Token token, Evaluated<T> value) {
    return new ImmutableValueNode<>(token, value);
  }

  /**
   * Creates an immutable copy of a {@link ValueNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ValueNode instance
   */
  public static <T> ImmutableValueNode<T> copyOf(ValueNode<T> instance) {
    if (instance instanceof ImmutableValueNode<?>) {
      return (ImmutableValueNode<T>) instance;
    }
    return ImmutableValueNode.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueNode ImmutableValueNode}.
   * <pre>
   * ImmutableValueNode.&amp;lt;T&amp;gt;builder()
   *    .token(de.flapdoodle.eval.core.parser.Token) // required {@link ValueNode#token() token}
   *    .value(de.flapdoodle.eval.core.evaluables.Evaluated&amp;lt;T&amp;gt;) // required {@link ValueNode#value() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableValueNode builder
   */
  public static <T> ImmutableValueNode.Builder<T> builder() {
    return new ImmutableValueNode.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableValueNode ImmutableValueNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueNode", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private Token token;
    private Evaluated<T> value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.ValueNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(ValueNode<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.Node} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Node instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(short _unused, Object object) {
      if (object instanceof ValueNode<?>) {
        ValueNode<T> instance = (ValueNode<T>) object;
        this.value(instance.value());
      }
      if (object instanceof Node) {
        Node instance = (Node) object;
        this.token(instance.token());
      }
    }

    /**
     * Initializes the value for the {@link ValueNode#token() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> token(Token token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueNode#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> value(Evaluated<T> value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueNode ImmutableValueNode}.
     * @return An immutable instance of ValueNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueNode<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableValueNode<>(null, token, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build ValueNode, some of required attributes are not set " + attributes;
    }
  }
}
