package de.flapdoodle.eval.core.evaluables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TypedEvaluables}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypedEvaluables.builder()}.
 */
@Generated(from = "TypedEvaluables", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTypedEvaluables extends TypedEvaluables {
  private final List<TypedEvaluable<?>> list;

  private ImmutableTypedEvaluables(List<TypedEvaluable<?>> list) {
    this.list = list;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  protected List<TypedEvaluable<?>> list() {
    return list;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TypedEvaluables#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableTypedEvaluables withList(TypedEvaluable<?>... elements) {
    List<TypedEvaluable<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTypedEvaluables(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TypedEvaluables#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypedEvaluables withList(Iterable<? extends TypedEvaluable<?>> elements) {
    if (this.list == elements) return this;
    List<TypedEvaluable<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTypedEvaluables(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypedEvaluables} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypedEvaluables
        && equalTo(0, (ImmutableTypedEvaluables) another);
  }

  private boolean equalTo(int synthetic, ImmutableTypedEvaluables another) {
    return list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypedEvaluables} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TypedEvaluables{"
        + "list=" + list
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TypedEvaluables} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TypedEvaluables instance
   */
  public static ImmutableTypedEvaluables copyOf(TypedEvaluables instance) {
    if (instance instanceof ImmutableTypedEvaluables) {
      return (ImmutableTypedEvaluables) instance;
    }
    return ImmutableTypedEvaluables.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypedEvaluables ImmutableTypedEvaluables}.
   * <pre>
   * ImmutableTypedEvaluables.builder()
   *    .addList|addAllList(de.flapdoodle.eval.core.evaluables.TypedEvaluable&amp;lt;?&amp;gt;) // {@link TypedEvaluables#list() list} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTypedEvaluables builder
   */
  public static ImmutableTypedEvaluables.Builder builder() {
    return new ImmutableTypedEvaluables.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTypedEvaluables ImmutableTypedEvaluables}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TypedEvaluables", generator = "Immutables")
  public static final class Builder {
    private List<TypedEvaluable<?>> list = new ArrayList<TypedEvaluable<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypedEvaluables} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TypedEvaluables instance) {
      Objects.requireNonNull(instance, "instance");
      addAllList(instance.list());
      return this;
    }

    /**
     * Adds one element to {@link TypedEvaluables#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addList(TypedEvaluable<?> element) {
      this.list.add(Objects.requireNonNull(element, "list element"));
      return this;
    }

    /**
     * Adds elements to {@link TypedEvaluables#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addList(TypedEvaluable<?>... elements) {
      for (TypedEvaluable<?> element : elements) {
        this.list.add(Objects.requireNonNull(element, "list element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TypedEvaluables#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder list(Iterable<? extends TypedEvaluable<?>> elements) {
      this.list.clear();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link TypedEvaluables#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllList(Iterable<? extends TypedEvaluable<?>> elements) {
      for (TypedEvaluable<?> element : elements) {
        this.list.add(Objects.requireNonNull(element, "list element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypedEvaluables ImmutableTypedEvaluables}.
     * @return An immutable instance of TypedEvaluables
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypedEvaluables build() {
      return new ImmutableTypedEvaluables(createUnmodifiableList(true, list));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
