/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.runtime;

import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.redis.config.RedisDConfig;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedisD {
    protected static Logger logger = Logger.getLogger(RedisD.class.getName());

    public static int getRedisdProcessId(String output, int defaultValue) {
        Pattern pattern = Pattern.compile("PID: ([1234567890]+)", 8);
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            String value = matcher.group(1);
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static List<String> getCommandLine(RedisDConfig config, IExtractedFileSet redisdExecutable, File dbDir, File dbFile, File pidFile) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(redisdExecutable.executable().getAbsolutePath(), "--port", "" + config.net().getPort(), "--dir", dbDir.getAbsolutePath(), "--pidfile", pidFile.getAbsolutePath(), "--dbfilename", dbFile.getName()));
        return ret;
    }

    public static List<String> enhanceCommandLinePlattformSpecific(Distribution distribution, List<String> commands) {
        return commands;
    }
}

