/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.config;

import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.redis.Command;
import de.flapdoodle.embed.redis.config.SupportConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class AbstractRedisConfig
extends ExecutableProcessConfig {
    protected final Net network;
    protected final Timeout timeout;
    protected boolean nested = false;

    public AbstractRedisConfig(IVersion version, Net networt, Timeout timeout) {
        super(version, (ISupportConfig)new SupportConfig(Command.RedisD));
        this.network = networt;
        this.timeout = timeout;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void nested() {
        this.nested = true;
    }

    public Net net() {
        return this.network;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public static class Timeout {
        private final long startupTimeout;

        public Timeout() {
            this(2000L);
        }

        public Timeout(long startupTimeout) {
            this.startupTimeout = startupTimeout;
        }

        public long getStartupTimeout() {
            return this.startupTimeout;
        }
    }

    public static class Net {
        private final int port;

        public Net() throws UnknownHostException, IOException {
            this(Network.getFreeServerPort());
        }

        public Net(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public InetAddress getServerAddress() throws UnknownHostException {
            return Network.getLocalHost();
        }
    }

    public static class Storage {
        private final String databaseDir;
        private final String databaseFile;
        private final String pidFile;

        public Storage() {
            this(null, null, null);
        }

        public Storage(String databaseDir, String databaseFile, String pidFile) {
            this.databaseDir = databaseDir;
            this.databaseFile = databaseFile;
            this.pidFile = pidFile;
        }

        public String getDatabaseDir() {
            return this.databaseDir;
        }

        public String getDatabaseFile() {
            return this.databaseFile;
        }

        public String getPidFile() {
            return this.pidFile;
        }
    }
}

