/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.redis.Command;
import java.util.logging.Logger;

public class PackagePaths
implements IPackageResolver {
    protected static Logger logger = Logger.getLogger(PackagePaths.class.getName());
    private final Command command;

    public PackagePaths(Command command) {
        this.command = command;
    }

    public FileSet getFileSet(Distribution distribution) {
        String redisdPattern;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: {
                redisdPattern = this.command.commandName();
                break;
            }
            case Windows: {
                redisdPattern = this.command.commandName() + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return FileSet.builder().addEntry(FileType.Executable, redisdPattern).build();
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String splatform;
        String sarchiveType;
        String sversion = PackagePaths.getVersionPart(distribution.getVersion());
        ArchiveType archiveType = this.getArchiveType(distribution);
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tar.gz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "windows";
                break;
            }
            case OS_X: {
                splatform = "macos";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return "/" + sversion + "/redis-dist-" + sversion + "-" + splatform + "." + sarchiveType;
    }

    protected static String getVersionPart(IVersion version) {
        return version.asInDownloadPath();
    }
}

