/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.tests;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.redis.Command;
import de.flapdoodle.embed.redis.RedisDExecutable;
import de.flapdoodle.embed.redis.RedisDProcess;
import de.flapdoodle.embed.redis.RedisDStarter;
import de.flapdoodle.embed.redis.config.AbstractRedisConfig;
import de.flapdoodle.embed.redis.config.RedisDConfig;
import de.flapdoodle.embed.redis.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.redis.distribution.Version;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import redis.clients.jedis.Jedis;

public class RedisDForTestsFactory {
    private static Logger logger = Logger.getLogger(RedisDForTestsFactory.class.getName());
    private final RedisDExecutable redisdExecutable;
    private final RedisDProcess redisdProcess;

    public static RedisDForTestsFactory with(IVersion version) throws IOException {
        return new RedisDForTestsFactory(version);
    }

    public RedisDForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public RedisDForTestsFactory(IVersion version) throws IOException {
        RedisDStarter runtime = RedisDStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.RedisD, logger).build());
        this.redisdExecutable = (RedisDExecutable)runtime.prepare((IExecutableProcessConfig)this.newRedisdConfig(version));
        this.redisdProcess = (RedisDProcess)this.redisdExecutable.start();
    }

    protected RedisDConfig newRedisdConfig(IVersion version) throws UnknownHostException, IOException {
        return new RedisDConfig(version, new AbstractRedisConfig.Net(), new AbstractRedisConfig.Storage(), new AbstractRedisConfig.Timeout());
    }

    public Jedis newJedis() throws UnknownHostException {
        return new Jedis(((RedisDConfig)this.redisdProcess.getConfig()).net().getServerAddress().getCanonicalHostName(), ((RedisDConfig)this.redisdProcess.getConfig()).net().getPort());
    }

    public void shutdown() {
        this.redisdProcess.stop();
        this.redisdExecutable.stop();
    }
}

