/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.redis.RedisDExecutable;
import de.flapdoodle.embed.redis.config.AbstractRedisConfig;
import de.flapdoodle.embed.redis.config.RedisDConfig;
import de.flapdoodle.embed.redis.runtime.RedisD;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisDProcess
extends AbstractProcess<RedisDConfig, RedisDExecutable, RedisDProcess> {
    private static Logger logger = Logger.getLogger(RedisDProcess.class.getName());
    private File dbDir;
    private File dbFile;
    private boolean dbDirIsTemp;
    private boolean dbFileIsTemp;
    boolean stopped = false;
    protected IRuntimeConfig redisCRuntimeConfig;

    public RedisDProcess(Distribution distribution, RedisDConfig config, IRuntimeConfig runtimeConfig, RedisDExecutable redisdExecutable) throws IOException {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, (Executable)redisdExecutable);
    }

    protected Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        RedisDProcess redisDProcess = this;
        synchronized (redisDProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("try to stop redisd");
                if (!this.sendStopToRedisInstance()) {
                    logger.warning("could not stop redisd with command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warning("could not stop redisd, try next");
                        if (!this.sendTermToProcess()) {
                            logger.warning("could not stop redisd, try next");
                            if (!this.tryKillToProcess()) {
                                logger.warning("could not stop redisd the second time, try one last thing");
                            }
                        }
                    }
                }
                this.stopProcess();
                this.deleteTempFiles();
            }
        }
    }

    protected final boolean sendStopToRedisInstance() {
        return RedisDProcess.shutdownRedis((AbstractRedisConfig)this.getConfig());
    }

    public static boolean shutdownRedis(AbstractRedisConfig config) {
        try {
            if (config.isNested()) {
                logger.log(Level.INFO, "Nested stop, won't execute redis process again");
                return false;
            }
            InetAddress host = config.net().getServerAddress();
            int port = config.net().getPort();
            if (!host.isLoopbackAddress()) {
                logger.log(Level.WARNING, "---------------------------------------\nYour localhost (" + host.getHostAddress() + ") is not a loopback adress\n" + "We can NOT send shutdown to redis, because it is denied from remote." + "---------------------------------------\n");
                return false;
            }
            try {
                Jedis j = new Jedis(host.getHostName(), port);
                String reply = j.shutdown();
                if (StringUtils.isEmpty((CharSequence)reply)) {
                    return true;
                }
                logger.log(Level.SEVERE, String.format("sendShutdown closing %s:%s; Got response from server %s", host, port, reply));
                return false;
            }
            catch (JedisConnectionException e) {
                logger.log(Level.WARNING, String.format("sendShutdown closing %s:%s. No Service listening on address.\n%s", host, port, e.getMessage()));
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }

    public void setRedisCRuntimeConfig(IRuntimeConfig redisCRuntimeConfig) {
        this.redisCRuntimeConfig = redisCRuntimeConfig;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        File tmpDbFile;
        File tmpDbDir;
        super.onBeforeProcess(runtimeConfig);
        RedisDConfig config = (RedisDConfig)this.getConfig();
        if (config.getStorage().getDatabaseDir() != null) {
            tmpDbDir = Files.createOrCheckDir((String)config.getStorage().getDatabaseDir());
        } else {
            tmpDbDir = Files.createTempDir((IDirectory)PropertyOrPlatformTempDir.defaultInstance(), (String)"embedredis-db");
            this.dbDirIsTemp = true;
        }
        this.dbDir = tmpDbDir;
        if (config.getStorage().getDatabaseFile() != null) {
            tmpDbFile = new File(config.getStorage().getDatabaseFile());
        } else {
            tmpDbFile = new File("dump.rdb");
            this.dbFileIsTemp = true;
        }
        this.dbFile = tmpDbFile;
    }

    protected List<String> getCommandLine(Distribution distribution, RedisDConfig config, IExtractedFileSet exe) throws IOException {
        return RedisD.enhanceCommandLinePlattformSpecific(distribution, RedisD.getCommandLine((RedisDConfig)this.getConfig(), exe, this.dbDir, this.dbFile, this.pidFile()));
    }

    protected void deleteTempFiles() {
        if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
            logger.warning("Could not delete temp db dir: " + this.dbDir);
        }
        if (this.dbFile != null && this.dbFileIsTemp && !Files.forceDelete((File)this.dbFile)) {
            logger.warning("Could not delete temp db file: " + this.dbFile);
        }
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("The server is now ready to accept connections on port", this.knownFailureMessages(), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(((RedisDConfig)this.getConfig()).timeout().getStartupTimeout());
        int redisdProcessId = RedisD.getRedisdProcessId(logWatch.getOutput(), -1);
        if (logWatch.isInitWithSuccess() && redisdProcessId != -1) {
            this.setProcessId(redisdProcessId);
        } else {
            this.setProcessId(RedisDProcess.getPidFromFile((File)this.pidFile()));
        }
    }

    protected void cleanupInternal() {
    }
}

