/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.tests;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.redis.Command;
import de.flapdoodle.embed.redis.RedisCliExecutable;
import de.flapdoodle.embed.redis.RedisCliProcess;
import de.flapdoodle.embed.redis.RedisCliStarter;
import de.flapdoodle.embed.redis.RedisDExecutable;
import de.flapdoodle.embed.redis.RedisDProcess;
import de.flapdoodle.embed.redis.RedisDStarter;
import de.flapdoodle.embed.redis.config.RedisCliConfig;
import de.flapdoodle.embed.redis.config.RedisDConfig;
import de.flapdoodle.embed.redis.config.RuntimeConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RedisCliSystemForTestFactory {
    private static final Logger logger = Logger.getLogger(RedisCliSystemForTestFactory.class.getName());
    private final RedisCliConfig config;
    private final List<RedisDConfig> configServers;
    private RedisCliExecutable redisCliExecutable;
    private RedisCliProcess redisCliProcess;
    private List<RedisDProcess> redisdProcessList;
    private List<RedisDProcess> redisdConfigProcessList;

    public RedisCliSystemForTestFactory(RedisCliConfig config, Map<String, List<RedisDConfig>> replicaSets, List<RedisDConfig> configServers, String shardDatabase, String shardCollection, String shardKey) {
        this.config = config;
        this.configServers = configServers;
    }

    public void start() throws Throwable {
        this.redisdProcessList = new ArrayList<RedisDProcess>();
        this.redisdConfigProcessList = new ArrayList<RedisDProcess>();
        for (RedisDConfig config : this.configServers) {
            this.initializeConfigServer(config);
        }
        this.initializeRedis();
    }

    private void initializeConfigServer(RedisDConfig config) throws Exception {
        RedisDStarter starter = RedisDStarter.getDefaultInstance();
        RedisDExecutable mongodExe = (RedisDExecutable)starter.prepare((IExecutableProcessConfig)config);
        RedisDProcess process = (RedisDProcess)mongodExe.start();
        this.redisdProcessList.add(process);
    }

    private void initializeRedis() throws Exception {
        RedisCliStarter runtime = RedisCliStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.RedisC, logger).build());
        this.redisCliExecutable = (RedisCliExecutable)runtime.prepare((IExecutableProcessConfig)this.config);
        this.redisCliProcess = (RedisCliProcess)this.redisCliExecutable.start();
    }

    public void stop() {
        for (RedisDProcess process : this.redisdProcessList) {
            process.stop();
        }
        for (RedisDProcess process : this.redisdConfigProcessList) {
            process.stop();
        }
        this.redisCliProcess.stop();
    }
}

