/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.redis.AbstractRedisProcess;
import de.flapdoodle.embed.redis.Command;
import de.flapdoodle.embed.redis.RedisDExecutable;
import de.flapdoodle.embed.redis.config.RedisDConfig;
import de.flapdoodle.embed.redis.config.SupportConfig;
import de.flapdoodle.embed.redis.runtime.RedisD;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;

public class RedisDProcess
extends AbstractRedisProcess<RedisDConfig, RedisDExecutable, RedisDProcess> {
    private static Logger logger = Logger.getLogger(RedisDProcess.class.getName());
    private File dbDir;
    private File dbFile;
    private boolean dbDirIsTemp;
    private boolean dbFileIsTemp;

    public RedisDProcess(Distribution distribution, RedisDConfig config, IRuntimeConfig runtimeConfig, RedisDExecutable redisdExecutable) throws IOException {
        super(distribution, config, runtimeConfig, redisdExecutable);
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        File tmpDbFile;
        File tmpDbDir;
        super.onBeforeProcess(runtimeConfig);
        RedisDConfig config = (RedisDConfig)this.getConfig();
        if (config.getStorage().getDatabaseDir() != null) {
            tmpDbDir = Files.createOrCheckDir((String)config.getStorage().getDatabaseDir());
        } else {
            tmpDbDir = Files.createTempDir((IDirectory)PropertyOrPlatformTempDir.defaultInstance(), (String)"embedredis-db");
            this.dbDirIsTemp = true;
        }
        this.dbDir = tmpDbDir;
        if (config.getStorage().getDatabaseFile() != null) {
            tmpDbFile = new File(this.dbDir, config.getStorage().getDatabaseFile());
        } else {
            tmpDbFile = new File(PropertyOrPlatformTempDir.defaultInstance().asFile(), "dump.rdb");
            this.dbFileIsTemp = true;
        }
        this.dbFile = tmpDbFile;
    }

    protected ISupportConfig supportConfig() {
        return new SupportConfig(Command.RedisD);
    }

    protected List<String> getCommandLine(Distribution distribution, RedisDConfig config, IExtractedFileSet exe) throws IOException {
        return RedisD.enhanceCommandLinePlattformSpecific(distribution, RedisD.getCommandLine((RedisDConfig)this.getConfig(), exe, this.dbDir, this.dbFile, this.pidFile()));
    }

    @Override
    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.dbDir != null && this.dbDirIsTemp && !Files.forceDelete((File)this.dbDir)) {
            logger.warning("Could not delete temp db dir: " + this.dbDir);
        }
        if (this.dbFile != null && this.dbFileIsTemp && !Files.forceDelete((File)this.dbFile)) {
            logger.warning("Could not delete temp db file: " + this.dbFile);
        }
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("The server is now ready to accept connections on port", this.knownFailureMessages(), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(((RedisDConfig)this.getConfig()).timeout().getStartupTimeout());
        int redisdProcessId = RedisD.getRedisdProcessId(logWatch.getOutput(), -1);
        if (logWatch.isInitWithSuccess() && redisdProcessId != -1) {
            this.setProcessId(redisdProcessId);
        } else {
            this.setProcessId(RedisDProcess.getPidFromFile((File)this.pidFile()));
        }
    }

    protected void cleanupInternal() {
    }
}

