/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.redis.AbstractRedisProcess;
import de.flapdoodle.embed.redis.RedisCliExecutable;
import de.flapdoodle.embed.redis.config.RedisCliConfig;
import de.flapdoodle.embed.redis.config.RedisCliSupportConfig;
import de.flapdoodle.embed.redis.runtime.RedisC;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Logger;

public class RedisCliProcess
extends AbstractRedisProcess<RedisCliConfig, RedisCliExecutable, RedisCliProcess> {
    private static Logger logger = Logger.getLogger(RedisCliProcess.class.getName());

    public RedisCliProcess(Distribution distribution, RedisCliConfig config, IRuntimeConfig runtimeConfig, RedisCliExecutable rediscExecutable) throws IOException {
        super(distribution, config, runtimeConfig, rediscExecutable);
    }

    protected ISupportConfig supportConfig() {
        return RedisCliSupportConfig.getInstance();
    }

    protected List<String> getCommandLine(Distribution distribution, RedisCliConfig config, IExtractedFileSet exe) throws IOException {
        return RedisC.getCommandLine((RedisCliConfig)this.getConfig(), exe);
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("", this.knownFailureMessages(), StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getOutput()));
        Processors.connect((Reader)process.getReader(), (IStreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (IStreamProcessor)StreamToLineProcessor.wrap((IStreamProcessor)outputConfig.getError()));
        logWatch.waitForResult(((RedisCliConfig)this.getConfig()).timeout().getStartupTimeout());
    }

    protected void cleanupInternal() {
    }
}

