/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.tests;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.redis.Command;
import de.flapdoodle.embed.redis.RedisCliExecutable;
import de.flapdoodle.embed.redis.RedisCliProcess;
import de.flapdoodle.embed.redis.RedisCliStarter;
import de.flapdoodle.embed.redis.config.AbstractRedisConfig;
import de.flapdoodle.embed.redis.config.RedisCliConfig;
import de.flapdoodle.embed.redis.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.redis.distribution.Version;
import java.io.IOException;
import java.util.logging.Logger;

public class RedisCliForTestsFactory {
    private static Logger logger = Logger.getLogger(RedisCliForTestsFactory.class.getName());
    private final RedisCliExecutable redisCliConfigExecutable;
    private final RedisCliProcess redisCliConfigProcess;
    private final RedisCliExecutable redisCliExecutable;
    private final RedisCliProcess redisCliProcess;

    public static RedisCliForTestsFactory with(IVersion version) throws IOException {
        return new RedisCliForTestsFactory(version);
    }

    public RedisCliForTestsFactory() throws IOException {
        this(Version.Main.DEVELOPMENT);
    }

    public RedisCliForTestsFactory(IVersion version) throws IOException {
        RedisCliStarter redisConfigRuntime = RedisCliStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.RedisC, logger).build());
        int configServerPort = 27019;
        int redissPort = 6379;
        this.redisCliConfigExecutable = (RedisCliExecutable)redisConfigRuntime.prepare((IExecutableProcessConfig)RedisCliConfig.getConfigInstance(version, new AbstractRedisConfig.Net(configServerPort)));
        this.redisCliConfigProcess = (RedisCliProcess)this.redisCliConfigExecutable.start();
        RedisCliStarter runtime = RedisCliStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.RedisC, logger).build());
        this.redisCliExecutable = (RedisCliExecutable)runtime.prepare((IExecutableProcessConfig)new RedisCliConfig(version, new AbstractRedisConfig.Net(redissPort), new AbstractRedisConfig.Timeout()));
        this.redisCliProcess = (RedisCliProcess)this.redisCliExecutable.start();
    }

    public void shutdown() {
        this.redisCliProcess.stop();
        this.redisCliExecutable.stop();
    }
}

