/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.redis.RedisCliExecutable;
import de.flapdoodle.embed.redis.RedisCliStarter;
import de.flapdoodle.embed.redis.config.AbstractRedisConfig;
import de.flapdoodle.embed.redis.config.RedisCliConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RedisC {
    private static Logger logger = Logger.getLogger(RedisC.class.getName());
    public static final int WAITING_TIME_SHUTDOWN_IN_MS = 500;

    public static List<String> getCommandLine(RedisCliConfig config, IExtractedFileSet rediscExecutable) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(rediscExecutable.executable().getAbsolutePath(), "-p", "" + config.net().getPort()));
        if (config.isShutdown()) {
            ret.add("SHUTDOWN");
        }
        return ret;
    }

    public static boolean sendShutdown(IVersion redisVersion, InetAddress hostname, int port, boolean isNested) {
        if (isNested) {
            logger.log(Level.INFO, "Nested stop, won't execute redis process again");
            return false;
        }
        if (!hostname.isLoopbackAddress()) {
            logger.log(Level.WARNING, "---------------------------------------\nYour localhost (" + hostname.getHostAddress() + ") is not a loopback adress\n" + "We can NOT send shutdown to redis, because it is denied from remote." + "---------------------------------------\n");
            return false;
        }
        try {
            RedisCliStarter runtime = RedisCliStarter.getDefaultInstance();
            RedisCliConfig redisCliConfig = new RedisCliConfig(redisVersion, new AbstractRedisConfig.Net(port), new AbstractRedisConfig.Timeout(500L), true);
            redisCliConfig.nested();
            RedisCliExecutable rediscliExe = (RedisCliExecutable)runtime.prepare((IExecutableProcessConfig)redisCliConfig);
            rediscliExe.start();
            return true;
        }
        catch (Exception iox) {
            logger.log(Level.SEVERE, String.format("sendShutdown closing %s:%s", hostname, port), iox);
            iox.printStackTrace();
            return false;
        }
    }
}

