/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.redis;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.redis.config.AbstractRedisConfig;
import de.flapdoodle.embed.redis.runtime.RedisC;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRedisProcess<T extends AbstractRedisConfig, E extends Executable<T, P>, P extends IStopable>
extends AbstractProcess<T, E, P> {
    private static Logger logger = Logger.getLogger(AbstractRedisProcess.class.getName());
    boolean stopped = false;

    public AbstractRedisProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
    }

    protected Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        AbstractRedisProcess abstractRedisProcess = this;
        synchronized (abstractRedisProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("try to stop redisd");
                if (!this.sendStopToRedisInstance()) {
                    logger.warning("could not stop redisd with command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warning("could not stop redisd, try next");
                        if (!this.sendTermToProcess()) {
                            logger.warning("could not stop redisd, try next");
                            if (!this.tryKillToProcess()) {
                                logger.warning("could not stop redisd the second time, try one last thing");
                            }
                        }
                    }
                }
                this.stopProcess();
                this.deleteTempFiles();
            }
        }
    }

    protected void deleteTempFiles() {
    }

    protected final boolean sendStopToRedisInstance() {
        try {
            boolean result = RedisC.sendShutdown(((AbstractRedisConfig)this.getConfig()).version(), ((AbstractRedisConfig)this.getConfig()).net().getServerAddress(), ((AbstractRedisConfig)this.getConfig()).net().getPort(), ((AbstractRedisConfig)this.getConfig()).isNested());
            return result;
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }
}

