/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoDatabase;
import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.spring.autoconfigure.AbstractServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class ReactiveClientServerFactory
extends AbstractServerFactory {
    private static Logger logger = LoggerFactory.getLogger(ReactiveClientServerFactory.class);

    ReactiveClientServerFactory(MongoProperties properties) {
        super(properties);
        logger.info("reactive server factory");
    }

    MongodWrapper createWrapper(IFeatureAwareVersion version, Mongod mongod, MongodArguments mongodArguments) {
        return new MongodWrapper(mongod.transitions((Version)version), this.addAuthUserToDB(this.properties), this.initReplicaSet(version, mongodArguments));
    }

    protected Listener initReplicaSet(IFeatureAwareVersion version, MongodArguments mongodArguments) {
        Listener.TypedListener.Builder builder = Listener.typedBuilder();
        if (mongodArguments.replication().isPresent() && version.enabled(Feature.RS_INITIATE)) {
            builder.onStateReached(StateID.of(RunningMongodProcess.class), runningMongodProcess -> {
                try (MongoClient client = ReactiveClientServerFactory.client(runningMongodProcess.getServerAddress());){
                    ReactiveClientServerFactory.get(client.getDatabase("admin").runCommand((Bson)Document.parse((String)"{replSetInitiate: {}}")));
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return builder.build();
    }

    @Override
    protected Consumer<RunningMongodProcess> addAuthUserToDBCallback(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            try {
                logger.info("enable " + username + " access for " + databaseName);
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                String adminDatabaseName = "admin";
                try (MongoClient client = ReactiveClientServerFactory.client(serverAddress);){
                    if (!ReactiveClientServerFactory.createUser(client.getDatabase(adminDatabaseName), username, password, "root")) {
                        throw new IllegalArgumentException("could not create " + username + " user in " + adminDatabaseName);
                    }
                }
                client = ReactiveClientServerFactory.client(serverAddress, MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password));
                try {
                    if (!ReactiveClientServerFactory.createUser(client.getDatabase(databaseName), username, password, "readWrite")) {
                        throw new IllegalArgumentException("could not create " + username + " in " + databaseName);
                    }
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
                client = ReactiveClientServerFactory.client(serverAddress, MongoCredential.createCredential((String)username, (String)"test", (char[])password));
                try {
                    Preconditions.checkNotNull((Object)client.getDatabase(databaseName).getName(), (String)"something went wrong", (Object[])new Object[0]);
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
                logger.info("access for " + username + "@" + databaseName + " is enabled");
            }
            catch (UnknownHostException ux) {
                throw new RuntimeException(ux);
            }
        };
    }

    @Override
    protected Consumer<RunningMongodProcess> sendShutdown(String username, char[] password, String databaseName) {
        return runningMongodProcess -> {
            try {
                logger.info("enable " + username + " access for " + databaseName + " - shutdown database");
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                String adminDatabaseName = "admin";
                try (MongoClient client = ReactiveClientServerFactory.client(serverAddress, MongoCredential.createCredential((String)username, (String)adminDatabaseName, (char[])password));){
                    ReactiveClientServerFactory.get(client.getDatabase(adminDatabaseName).runCommand((Bson)new Document().append("shutdown", (Object)1)));
                }
                logger.info("access for " + username + "@" + databaseName + " is enabled - shutdown done");
            }
            catch (UnknownHostException ux) {
                throw new RuntimeException(ux);
            }
        };
    }

    private static MongoClient client(ServerAddress serverAddress) {
        return MongoClients.create((String)("mongodb://" + serverAddress));
    }

    private static MongoClient client(ServerAddress serverAddress, MongoCredential credential) {
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + serverAddress)).credential(credential).build());
    }

    private static boolean createUser(MongoDatabase db, String username, char[] password, String ... roles) {
        Publisher result = db.runCommand((Bson)new Document().append("createUser", (Object)username).append("pwd", (Object)new String(password)).append("roles", Arrays.asList(roles)));
        return (Double)((Document)Preconditions.checkNotNull((Object)((Document)ReactiveClientServerFactory.get(result)), (String)"create user failed", (Object[])new Object[0])).get((Object)"ok", Double.class) >= 1.0;
    }

    private static <T> T get(Publisher<T> publisher) {
        final CompletableFuture result = new CompletableFuture();
        publisher.subscribe(new Subscriber<T>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(T t) {
                result.complete(t);
            }

            public void onError(Throwable t) {
                result.completeExceptionally(t);
            }

            public void onComplete() {
            }
        });
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

