/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import de.flapdoodle.embed.mongo.commands.ImmutableMongodArguments;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.mongo.spring.autoconfigure.EmbeddedMongoProperties;
import de.flapdoodle.embed.mongo.spring.autoconfigure.MongodWrapper;
import de.flapdoodle.embed.mongo.spring.autoconfigure.ReactiveClientServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.SyncClientServerFactory;
import de.flapdoodle.embed.mongo.spring.autoconfigure.TypedBeanPostProcessor;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.mongo.types.DatabaseDir;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.progress.ProgressListener;
import de.flapdoodle.embed.process.io.progress.Slf4jProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.Start;
import de.flapdoodle.types.Try;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.data.mongo.ReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.data.mongodb.core.ReactiveMongoClientFactoryBean;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MongoProperties.class, EmbeddedMongoProperties.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class, org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoAutoConfiguration.class})
@ConditionalOnClass(value={MongoClientSettings.class, Mongod.class})
@Import(value={EmbeddedMongoClientDependsOnBeanFactoryPostProcessor.class, EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor.class})
public class EmbeddedMongoAutoConfiguration {
    private static final byte[] IP4_LOOPBACK_ADDRESS = new byte[]{127, 0, 0, 1};
    private static final byte[] IP6_LOOPBACK_ADDRESS = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};

    @Bean
    public IFeatureAwareVersion version(EmbeddedMongoProperties embeddedProperties) {
        return EmbeddedMongoAutoConfiguration.determineVersion("de.flapdoodle", embeddedProperties.getVersion());
    }

    private static IFeatureAwareVersion determineVersion(String prefix, String version) {
        Assert.state((version != null ? 1 : 0) != 0, (String)("Set the " + prefix + ".mongodb.embedded.version property or define your own " + IFeatureAwareVersion.class.getSimpleName() + " bean to use embedded MongoDB"));
        return Versions.withFeatures((Version)EmbeddedMongoAutoConfiguration.createEmbeddedMongoVersion(version));
    }

    private static Version.GenericVersion createEmbeddedMongoVersion(String version) {
        return Version.of((String)version);
    }

    @Bean
    public Net net(ApplicationContext context, MongoProperties properties) throws IOException {
        Integer configuredPort = properties.getPort();
        Net net = EmbeddedMongoAutoConfiguration.net(properties, configuredPort);
        if (configuredPort == null || configuredPort == 0) {
            EmbeddedMongoAutoConfiguration.setEmbeddedPort(context, net.getPort());
        }
        return net;
    }

    private static InetAddress getHost(MongoProperties properties) throws UnknownHostException {
        if (properties.getHost() == null) {
            return InetAddress.getByAddress(Network.localhostIsIPv6() ? IP6_LOOPBACK_ADDRESS : IP4_LOOPBACK_ADDRESS);
        }
        return InetAddress.getByName(properties.getHost());
    }

    private static Net net(MongoProperties properties, Integer configuredPort) throws IOException {
        InetAddress host = EmbeddedMongoAutoConfiguration.getHost(properties);
        return configuredPort != null && configuredPort > 0 ? Net.of((String)host.getHostAddress(), (int)configuredPort, (boolean)Network.localhostIsIPv6()) : Net.of((String)host.getHostAddress(), (int)Network.freeServerPort((InetAddress)host), (boolean)Network.localhostIsIPv6());
    }

    @Bean
    @ConditionalOnMissingBean
    public Mongod mongod(MongodArguments mongodArguments, ProcessOutput processOutput, Net net, ProgressListener progressListener, EmbeddedMongoProperties embeddedProperties) {
        ImmutableMongod copy = Mongod.builder().mongodArguments((Transition)Start.to(MongodArguments.class).initializedWith((Object)mongodArguments)).net((Transition)Start.to(Net.class).initializedWith((Object)net)).processOutput((Transition)Start.to(ProcessOutput.class).initializedWith((Object)processOutput)).build();
        if (progressListener != null) {
            copy = copy.withProgressListener((Transition)Start.to(ProgressListener.class).initializedWith((Object)progressListener));
        }
        if (embeddedProperties.getDatabaseDir() != null) {
            Path databaseDirPath = Paths.get(embeddedProperties.getDatabaseDir(), new String[0]);
            if (!Files.exists(databaseDirPath, new LinkOption[0])) {
                Try.run(() -> Files.createDirectories(databaseDirPath, new FileAttribute[0]));
            }
            copy = copy.withDatabaseDir((Transition)Start.to(DatabaseDir.class).initializedWith((Object)DatabaseDir.of((Path)databaseDirPath)));
        }
        return copy;
    }

    @Bean
    @ConditionalOnMissingBean
    public ProgressListener progressListener() {
        return new Slf4jProgressListener(EmbeddedMongoAutoConfiguration.logger());
    }

    @Bean
    @ConditionalOnMissingBean
    public ProcessOutput processOutput() {
        Logger logger = EmbeddedMongoAutoConfiguration.logger();
        return ProcessOutput.builder().output(Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.INFO)).error(Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.ERROR)).commands(Processors.named((String)"[console>]", (StreamProcessor)Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.DEBUG))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public MongodArguments mongodArguments() {
        return MongodArguments.defaults();
    }

    @Bean
    public BeanPostProcessor fixTransactionAndAuth(EmbeddedMongoProperties embeddedProperties, MongoProperties mongoProperties) {
        EmbeddedMongoProperties.Storage storage = embeddedProperties.getStorage();
        return new TypedBeanPostProcessor<MongodArguments>(MongodArguments.class, src -> {
            ImmutableMongodArguments.Builder builder = MongodArguments.builder().from(src);
            if (storage != null && storage.getReplSetName() != null && !src.replication().isPresent()) {
                String replSetName = storage.getReplSetName();
                int oplogSize = storage.getOplogSize() != null ? (int)storage.getOplogSize().toMegabytes() : 0;
                builder.replication(Storage.of((String)replSetName, (int)oplogSize)).useNoJournal(false);
            } else if (src.replication().isPresent()) {
                builder.useNoJournal(false);
            }
            if (mongoProperties.getUsername() != null && mongoProperties.getPassword() != null) {
                builder.auth(true);
            }
            return builder.build();
        }, Function.identity());
    }

    private static Logger logger() {
        return LoggerFactory.getLogger((String)(EmbeddedMongoAutoConfiguration.class.getPackage().getName() + ".EmbeddedMongo"));
    }

    private static void setEmbeddedPort(ApplicationContext context, int port) {
        EmbeddedMongoAutoConfiguration.setPortProperty(context, port);
    }

    private static void setPortProperty(ApplicationContext currentContext, int port) {
        if (currentContext instanceof ConfigurableApplicationContext) {
            MutablePropertySources sources = ((ConfigurableApplicationContext)currentContext).getEnvironment().getPropertySources();
            EmbeddedMongoAutoConfiguration.getMongoPorts(sources).put("local.mongo.port", port);
        }
        if (currentContext.getParent() != null) {
            EmbeddedMongoAutoConfiguration.setPortProperty(currentContext.getParent(), port);
        }
    }

    private static Map<String, Object> getMongoPorts(MutablePropertySources sources) {
        PropertySource propertySource = sources.get("mongo.ports");
        if (propertySource == null) {
            propertySource = new MapPropertySource("mongo.ports", new HashMap());
            sources.addFirst(propertySource);
        }
        return (Map)propertySource.getSource();
    }

    @ConditionalOnClass(value={com.mongodb.reactivestreams.client.MongoClient.class, ReactiveMongoClientFactoryBean.class})
    static class EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor
    extends ReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor {
        EmbeddedReactiveStreamsMongoClientDependsOnBeanFactoryPostProcessor() {
            super(new Class[]{MongodWrapper.class});
        }
    }

    @ConditionalOnClass(value={MongoClient.class, MongoClientFactoryBean.class})
    static class EmbeddedMongoClientDependsOnBeanFactoryPostProcessor
    extends MongoClientDependsOnBeanFactoryPostProcessor {
        EmbeddedMongoClientDependsOnBeanFactoryPostProcessor() {
            super(new Class[]{MongodWrapper.class});
        }
    }

    @ConditionalOnClass(value={com.mongodb.reactivestreams.client.MongoClient.class, ReactiveMongoClientFactoryBean.class})
    static class ReactiveClientServerWrapperConfig {
        ReactiveClientServerWrapperConfig() {
        }

        @Bean(initMethod="start", destroyMethod="stop")
        @ConditionalOnMissingBean
        public MongodWrapper reactiveClientServerWrapper(IFeatureAwareVersion version, MongoProperties properties, Mongod mongod, MongodArguments mongodArguments) {
            return new ReactiveClientServerFactory(properties).createWrapper(version, mongod, mongodArguments);
        }
    }

    @ConditionalOnClass(value={MongoClient.class, MongoClientFactoryBean.class})
    static class SyncClientServerWrapperConfig {
        SyncClientServerWrapperConfig() {
        }

        @Bean(initMethod="start", destroyMethod="stop")
        @ConditionalOnMissingBean
        public MongodWrapper syncClientServerWrapper(IFeatureAwareVersion version, MongoProperties properties, Mongod mongod, MongodArguments mongodArguments) {
            return new SyncClientServerFactory(properties).createWrapper(version, mongod, mongodArguments);
        }
    }
}

