/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public abstract class AbstractServerFactory {
    protected final MongoProperties properties;

    protected AbstractServerFactory(MongoProperties properties) {
        this.properties = properties;
    }

    protected final Listener addAuthUserToDB(MongoProperties properties) {
        Listener.TypedListener.Builder typedBuilder = Listener.typedBuilder();
        String username = properties.getUsername();
        char[] password = properties.getPassword();
        String databaseName = properties.getMongoClientDatabase();
        if (username != null && password != null) {
            typedBuilder.onStateReached(StateID.of(RunningMongodProcess.class), this.addAuthUserToDBCallback(username, password, databaseName));
            typedBuilder.onStateTearDown(StateID.of(RunningMongodProcess.class), this.sendShutdown(username, password, databaseName));
        }
        return typedBuilder.build();
    }

    protected abstract Consumer<RunningMongodProcess> addAuthUserToDBCallback(String var1, char[] var2, String var3);

    protected abstract Consumer<RunningMongodProcess> sendShutdown(String var1, char[] var2, String var3);
}

