package de.flapdoodle.embed.mongo.packageresolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PackageFinderRules}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePackageFinderRules.builder()}.
 */
@Generated(from = "PackageFinderRules", generator = "Immutables")
@SuppressWarnings({"all"})
public final class ImmutablePackageFinderRules
    extends PackageFinderRules {
  private final List<PackageFinderRule> rules;

  private ImmutablePackageFinderRules(List<PackageFinderRule> rules) {
    this.rules = rules;
  }

  /**
   * @return The value of the {@code rules} attribute
   */
  @Override
  List<PackageFinderRule> rules() {
    return rules;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PackageFinderRules#rules() rules}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageFinderRules withRules(PackageFinderRule... elements) {
    List<PackageFinderRule> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePackageFinderRules(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PackageFinderRules#rules() rules}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of rules elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageFinderRules withRules(Iterable<? extends PackageFinderRule> elements) {
    if (this.rules == elements) return this;
    List<PackageFinderRule> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePackageFinderRules(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePackageFinderRules} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePackageFinderRules
        && equalTo(0, (ImmutablePackageFinderRules) another);
  }

  private boolean equalTo(int synthetic, ImmutablePackageFinderRules another) {
    return rules.equals(another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + rules.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PackageFinderRules} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PackageFinderRules{"
        + "rules=" + rules
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PackageFinderRules} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PackageFinderRules instance
   */
  public static ImmutablePackageFinderRules copyOf(PackageFinderRules instance) {
    if (instance instanceof ImmutablePackageFinderRules) {
      return (ImmutablePackageFinderRules) instance;
    }
    return ImmutablePackageFinderRules.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePackageFinderRules ImmutablePackageFinderRules}.
   * <pre>
   * ImmutablePackageFinderRules.builder()
   *    .addRules|addAllRules(de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule) // {@link PackageFinderRules#rules() rules} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePackageFinderRules builder
   */
  public static ImmutablePackageFinderRules.Builder builder() {
    return new ImmutablePackageFinderRules.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePackageFinderRules ImmutablePackageFinderRules}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PackageFinderRules", generator = "Immutables")
  public static final class Builder {
    private List<PackageFinderRule> rules = new ArrayList<PackageFinderRule>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PackageFinderRules} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PackageFinderRules instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRules(instance.rules());
      return this;
    }

    /**
     * Adds one element to {@link PackageFinderRules#rules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRules(PackageFinderRule element) {
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link PackageFinderRules#rules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addRules(PackageFinderRule... elements) {
      for (PackageFinderRule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PackageFinderRules#rules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Iterable<? extends PackageFinderRule> elements) {
      this.rules.clear();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link PackageFinderRules#rules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends PackageFinderRule> elements) {
      for (PackageFinderRule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutablePackageFinderRules ImmutablePackageFinderRules}.
     * @return An immutable instance of PackageFinderRules
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePackageFinderRules build() {
      return new ImmutablePackageFinderRules(createUnmodifiableList(true, rules));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
