/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.AbstractPackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasLabel;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;

public class LinuxLegacyPackageFinder
extends AbstractPackageFinder
implements HasLabel {
    public LinuxLegacyPackageFinder(Command command) {
        super(command, LinuxLegacyPackageFinder.rules(command));
    }

    @Override
    public String label() {
        return this.getClass().getSimpleName();
    }

    private static FileSet fileSetOf(Command command) {
        return FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        FileSet fileSet = LinuxLegacyPackageFinder.fileSetOf(command);
        ImmutablePackageFinderRule rule_Linux_X86_B64 = PackageFinderRule.builder().match(LinuxLegacyPackageFinder.match((OS)CommonOS.Linux, BitSize.B64, CPUType.X86, new Version[0]).andThen(DistributionMatch.any(VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.0", "3.6.23"), VersionRange.of("3.5.5"), VersionRange.of("3.4.9", "3.4.24"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.3.1"), VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15"), VersionRange.of("2.6.0", "2.6.12")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-{version}.tgz").build()).build();
        ImmutablePackageFinderRule rule_Linux_X86_B32 = PackageFinderRule.builder().match(LinuxLegacyPackageFinder.match((OS)CommonOS.Linux, BitSize.B32, CPUType.X86, new Version[0]).andThen(DistributionMatch.any(VersionRange.of("3.5.5"), VersionRange.of("3.3.1"), VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15"), VersionRange.of("2.6.0", "2.6.12")))).finder(UrlTemplatePackageFinder.builder().fileSet(fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-i686-{version}.tgz").build()).build();
        switch (command) {
            case Mongo: 
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withAdditionalRules(rule_Linux_X86_B64).withAdditionalRules(rule_Linux_X86_B32);
            }
        }
        return PackageFinderRules.empty().withAdditionalRules(rule_Linux_X86_B64).withAdditionalRules(rule_Linux_X86_B32);
    }
}

