/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver.linux;

import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.ImmutablePlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRule;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.UrlTemplatePackageResolver;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import de.flapdoodle.embed.process.config.store.DistributionPackage;
import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.ImmutableFileSet;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.OS;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.linux.AmazonVersion;
import java.util.Optional;

public class AmazonPackageResolver
implements PackageFinder,
HasPlatformMatchRules {
    private final ImmutablePackageFinderRules rules;

    public AmazonPackageResolver(Command command) {
        this.rules = AmazonPackageResolver.rules(command);
    }

    @Override
    public PackageFinderRules rules() {
        return this.rules;
    }

    @Override
    public Optional<DistributionPackage> packageFor(Distribution distribution) {
        return this.rules.packageFor(distribution);
    }

    private static ImmutablePackageFinderRules rules(Command command) {
        ImmutableFileSet fileSet = FileSet.builder().addEntry(FileType.Executable, command.commandName()).build();
        DistributionMatch amazon2ArmMongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.4", "4.4.9"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.13", "4.2.16"));
        ImmutablePackageFinderRule amazon2Arm = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.ARM, AmazonVersion.AmazonLinux2).andThen(amazon2ArmMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-aarch64-amazon2-{version}.tgz").build()).build();
        ImmutablePackageFinderRule amazon2ArmTools = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.ARM, AmazonVersion.AmazonLinux2).andThen(amazon2ArmMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-arm64-{tools.version}.tgz").build()).build();
        DistributionMatch amazon2MongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.22", "3.6.23"));
        ImmutablePackageFinderRule amazon2 = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.X86, AmazonVersion.AmazonLinux2).andThen(amazon2MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon2-{version}.tgz").build()).build();
        ImmutablePackageFinderRule amazon2tools = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.X86, AmazonVersion.AmazonLinux2).andThen(amazon2MongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon2-x86_64-{tools.version}.tgz").build()).build();
        DistributionMatch amazonMongoVersions = DistributionMatch.any(VersionRange.of("5.0.5", "5.0.6"), VersionRange.of("5.0.0", "5.0.2"), VersionRange.of("4.4.13", "4.4.13"), VersionRange.of("4.4.11", "4.4.11"), VersionRange.of("4.4.0", "4.4.9"), VersionRange.of("4.2.18", "4.2.19"), VersionRange.of("4.2.5", "4.2.16"), VersionRange.of("4.2.0", "4.2.3"), VersionRange.of("4.0.0", "4.0.28"), VersionRange.of("3.6.0", "3.6.23"), VersionRange.of("3.4.9", "3.4.24"), VersionRange.of("3.4.0", "3.4.7"), VersionRange.of("3.2.0", "3.2.22"), VersionRange.of("3.0.0", "3.0.15"));
        ImmutablePackageFinderRule amazon = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.X86, AmazonVersion.AmazonLinux).andThen(amazonMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/linux/mongodb-linux-x86_64-amazon-{version}.tgz").build()).build();
        ImmutablePackageFinderRule amazontools = PackageFinderRule.builder().match(AmazonPackageResolver.match(BitSize.B64, CPUType.X86, AmazonVersion.AmazonLinux).andThen(amazonMongoVersions)).finder(UrlTemplatePackageResolver.builder().fileSet((FileSet)fileSet).archiveType(ArchiveType.TGZ).urlTemplate("/tools/db/mongodb-database-tools-amazon-x86_64-{tools.version}.tgz").build()).build();
        switch (command) {
            case MongoDump: 
            case MongoImport: 
            case MongoRestore: {
                return PackageFinderRules.empty().withRules(amazon2ArmTools, amazon2tools, amazontools);
            }
        }
        return PackageFinderRules.empty().withRules(amazon2Arm, amazon2, amazon);
    }

    private static ImmutablePlatformMatch match(BitSize bitSize, CPUType cpuType, AmazonVersion version) {
        return PlatformMatch.withOs(OS.Linux).withVersion(new Version[]{version}).withBitSize(bitSize).withCpuType(cpuType);
    }
}

